% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{forecast.ESN}
\alias{forecast.ESN}
\title{Forecast an Echo State Network}
\usage{
\method{forecast}{ESN}(
  object,
  new_data,
  normal = TRUE,
  n_sim = 200,
  specials = NULL,
  xreg = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{mdl_df}, containing an ESN model.}

\item{new_data}{Forecast horizon (n-step ahead forecast).}

\item{normal}{Logical value. If \code{TRUE}, \code{dist_normal()} is used, otherwise \code{dist_sample()}.}

\item{n_sim}{Integer value. The number of future sample path generated during simulation.}

\item{specials}{Currently not in use.}

\item{xreg}{A \code{tsibble} containing exogenous variables.}

\item{...}{Currently not in use.}
}
\value{
An object of class \code{fbl_ts} ("fable").
}
\description{
Forecast an Echo State Network (ESN) from a trained model via
   recursive forecasting. Forecast intervals are generated by simulating
   future sample path based on a moving block bootstrap of the residuals and
   estimating the quantiles from the simulations. The function is a wrapper
   for \code{forecast_esn()} and intended to be used in combination with
   \code{fabletools::model()}.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
forecast(h = 18)

}
\seealso{
Other tidy functions: 
\code{\link{ESN}()},
\code{\link{filter_esn}()},
\code{\link{fitted.ESN}()},
\code{\link{glance.ESN}()},
\code{\link{model_sum.ESN}()},
\code{\link{report.ESN}()},
\code{\link{reservoir}()},
\code{\link{residuals.ESN}()},
\code{\link{tidy.ESN}()}
}
\concept{tidy functions}
