% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_gov_exp_share_column}
\alias{add_gov_exp_share_column}
\title{Add Government Expenditure as Share of GDP to Country Data}
\usage{
add_gov_exp_share_column(
  df,
  id_column,
  id_type = "iso3_code",
  date_column = NULL,
  target_column = "gov_exp_share"
)
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{id_type}{Type of country identifier. Defaults to "iso3_code".}

\item{date_column}{Optional. Name of the column containing dates for
time-specific data.}

\item{target_column}{Name of the output column. Defaults to "gov_exp".}
}
\value{
A data frame with an additional column containing government
expenditure as share of GDP data.
}
\description{
Add Government Expenditure as Share of GDP to Country Data
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# Add government expenditure share of GDP
df <- data.frame(country = c("USA", "JPN", "AUS"))
result <- add_gov_exp_share_column(df, id_column = "country")

# With specific years
df <- data.frame(country = c("USA", "JPN"), year = c(2015, 2020))
result <- add_gov_exp_share_column(
  df, id_column = "country", date_column = "year"
)
}
\dontshow{\}) # examplesIf}
}
