% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{eg_oauth_password}
\alias{eg_oauth_password}
\title{Authenticate with Egnyte Using Username and Password}
\usage{
eg_oauth_password(username = NULL, password = NULL)
}
\arguments{
\item{username}{Egnyte username. If NULL, checks the \code{EGNYTE_USERNAME}
environment variable.}

\item{password}{Egnyte password. If NULL, checks the \code{EGNYTE_PASSWORD}
environment variable.}
}
\value{
Invisibly returns a list containing \code{access_token} and \code{expires_in}.
}
\description{
Uses the OAuth 2.0 Resource Owner Password flow to obtain an access token
directly using Egnyte credentials. This is simpler than the Authorization
Code flow and doesn't require browser interaction.
}
\details{
This flow is intended for internal applications where the user trusts the
application with their credentials. The username and password are sent
directly to Egnyte's token endpoint.

You must first configure the OAuth app with \code{\link[=eg_oauth_app]{eg_oauth_app()}}.

Credentials can be provided via:
\itemize{
\item Function arguments
\item Environment variables: \code{EGNYTE_USERNAME}, \code{EGNYTE_PASSWORD}
\item Interactive prompt (if running interactively and not provided)
}

\strong{Note:} This flow does not return a refresh token. When the access token
expires (after 30 days), you'll need to authenticate again.
}
\examples{
\dontrun{
# Set up your OAuth app first
eg_oauth_app("mycompany", "client_id", "client_secret")

# Authenticate with username/password
eg_oauth_password("myuser", "mypassword")

# Or use environment variables
Sys.setenv(EGNYTE_USERNAME = "myuser", EGNYTE_PASSWORD = "mypassword")
eg_oauth_password()

# Now you can use eg_read() and eg_write()
eg_read("/Shared/Documents/file.txt", "local.txt")
}

}
\seealso{
\code{\link[=eg_oauth_app]{eg_oauth_app()}} to configure the OAuth application first.
}
