% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{string_list_to_int_cocktails}
\alias{string_list_to_int_cocktails}
\title{Function used to convert a string vector of drugs in form "drug1:drug2" to 
a vector of index of the ATC tree ex: c(ATC_index(drug1), ATC_index(drugs2))}
\usage{
string_list_to_int_cocktails(ATC_name, lines, last_element = FALSE)
}
\arguments{
\item{ATC_name}{the ATC_name column of the ATC tree}

\item{lines}{A string vector of drugs cocktail in the form "drug1:drug2:...:drug_n"}

\item{last_element}{A boolean to indicate whether we are matching the drug to 
the first matching occurrence in the tree or the last one. Default is false}
}
\value{
An R List that can be used by other algorithms (e.g. clustering algorithm)
}
\description{
Function used to convert a string vector of drugs in form "drug1:drug2" to 
a vector of index of the ATC tree ex: c(ATC_index(drug1), ATC_index(drugs2))
}
\examples{
\donttest{
  data("ATC_Tree_UpperBound_2024")
  string_list = c('hmg coa reductase inhibitors:nervous system',
                  'metformin:prasugrel')
  string_list_to_int_cocktails(ATC_Tree_UpperBound_2024$Name,
                              string_list)
}
}
