% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.spcache.R
\name{.spcache.net-ergmAuxiliary}
\alias{.spcache.net-ergmAuxiliary}
\alias{InitErgmTerm..spcache.net}
\title{Shared Partner Cache}
\usage{
# binary: .spcache(type)
}
\arguments{
\item{type}{A string indicating the type of shared partner or path to be considered for directed networks: \code{"OTP"} (default for directed), \code{"ITP"}, \code{"RTP"}, \code{"OSP"}, and \code{"ISP"}; has no effect for undirected. See the section below on Shared partner types for details.}
}
\description{
This auxiliary maintains a hash table mapping dyads to
shared partner counts.
}
\details{
This auxiliary maintains a single \code{StrictDyadMapUInt}
defined in \file{"ergm_dyad_hashmap.h"}. It is, internally, a
\code{khash} table mapping a pair of \code{Vertex}es (in a
\code{TailHead} structure) onto an \code{unsigned int}.

To make use of it in your change statistic:
\enumerate{
\item Add \code{auxiliaries = ~.spcache.net(type)} to the \code{InitErgmTerm}
output list. You may request it multiple times and/or alongside
other auxiliaries.
\item Add \verb{#include "ergm_dyad_hashmap.h"} to the top of your change
statistic implementation file.
\item In the function (e.g., \code{c_} function) implementing the change
statistic, use \code{GET_AUX_STORAGE(StoreStrictDyadMapUInt,
   spcache);} to obtain it if this is your first or only auxiliary,
or \code{GET_AUX_STORAGE(ind, StoreStrictDyadMapUInt, spcache);} if it is not.
\item Use one of the following macros to access the shared partner count: \describe{
\item{\code{GETUDMUI(\var{TAIL}, \var{HEAD}, spcache)}}{if undirected;}
\item{\code{GETDDMUI(\var{HEAD}, \var{TAIL}, spcache)}}{if \code{type = "ITP"} (since ITP is OTP with direction reversed);}
\item{\code{GETDDMUI(\var{TAIL}, \var{HEAD}, spcache)}}{in all other cases.}
}
}
}
\section{Shared partner types}{
 While there is only one shared partner configuration in the undirected
case, nine distinct configurations are possible for directed graphs, selected
using the \code{type} argument. Currently, terms may be defined with respect to
five of these configurations; they are defined here as follows (using
terminology from \insertCite{Bu08r;textual}{ergm} and the \code{relevent} package):
\itemize{
\item Outgoing Two-path (\code{"OTP"}): vertex \eqn{k} is an OTP shared partner of ordered
pair \eqn{(i,j)} iff \eqn{i \to k \to j}{i->k->j}. Also known as "transitive
shared partner".
\item Incoming Two-path (\code{"ITP"}): vertex \eqn{k} is an ITP shared partner of ordered
pair \eqn{(i,j)} iff \eqn{j \to k \to i}{j->k->i}. Also known as "cyclical shared
partner"
\item Reciprocated Two-path (\code{"RTP"}): vertex \eqn{k} is an RTP shared partner of ordered
pair \eqn{(i,j)} iff \eqn{i \leftrightarrow k \leftrightarrow j}{i<->k<->j}.
\item Outgoing Shared Partner (\code{"OSP"}): vertex \eqn{k} is an OSP shared partner of
ordered pair \eqn{(i,j)} iff \eqn{i \to k, j \to k}{i->k, j->k}.
\item Incoming Shared Partner (\code{"ISP"}): vertex \eqn{k} is an ISP shared partner of ordered
pair \eqn{(i,j)} iff \eqn{k \to i, k \to j}{k->i, k->j}.
}

By default, outgoing two-paths (\code{"OTP"}) are calculated. Note that \insertCite{RoPa09c;textual}{ergm}
define closely related statistics to several of the above, using slightly different terminology.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link{ergmAuxiliary}} for index of auxiliaries currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmAuxiliary", ".spcache.net", "subsection")}
}
\concept{directed}
\concept{triad-related}
\concept{undirected}
\keyword{internal}
