% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{I-ergmTerm}
\alias{I-ergmTerm}
\alias{InitErgmTerm.I}
\alias{InitWtErgmTerm.I}
\title{Substitute a formula into the model formula}
\usage{
# binary: I(formula)

# valued: I(formula)
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}
}
\description{
This is a convenience operator that can be used to
paste terms constructed elsewhere into a formula.
}
\note{
\code{formula} can also be a \code{\link[statnet.common:term_list]{term_list}} or \code{\link{character}}. In
the latter case, if there are multiple strings, they will be
concatenated with \code{+}, and if they do not start with "~", one
will be prepended. Its environment will be inherited from the
top-level formula.
}
\examples{
data(florentine)

(terms <- paste0("degree(", 0:5, ")"))
(s <- summary(flomarriage ~ I(terms)))

\dontshow{
stopifnot(identical(s, summary(flomarriage ~ degree(0:5))))
}
}
\seealso{
\code{\link[base:AsIs]{base::I()}} (a.k.a. \code{AsIs})

\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "I", "subsection")}
}
\concept{operator}
