% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_sari_positivity.R
\name{get_sari_positivity}
\alias{get_sari_positivity}
\title{Get ERVISS SARI tests/detections/positivity data}
\usage{
get_sari_positivity(
  csv_file = NULL,
  date_min,
  date_max,
  pathogen = "",
  indicator = "",
  age = "",
  countries = "",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{pathogen}{Character vector of pathogen names to filter.
Use "" (default) to include all pathogens.}

\item{indicator}{Character vector of indicators to filter:
"positivity", "detections", "tests", or any combination.
Use "" (default) to include all indicators.}

\item{age}{Character vector of age groups to filter (e.g., "total", "0-4",
"5-14", "15-64", "65+").
Use "" (default) to include all age groups.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A data.table containing the filtered SARI data with columns:
survtype, countryname, date, pathogen, pathogentype, pathogensubtype,
indicator, age, value.
}
\description{
Retrieves and filters SARI (Severe Acute Respiratory Infection) virological
data (tests, detections, positivity) from the ERVISS (European Respiratory
Virus Surveillance Summary) for a specified date range, pathogen(s),
indicator(s), age group(s), and country(ies).
}
\examples{
\donttest{
# Get SARI positivity data for Influenza in France
data <- get_sari_positivity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  pathogen = "Influenza",
  indicator = "positivity",
  countries = "France"
)

# Get all SARI indicators for SARS-CoV-2
data <- get_sari_positivity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  pathogen = "SARS-CoV-2"
)
}
}
