% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_boin_comb_mtd.R
\name{select_boin_comb_mtd}
\alias{select_boin_comb_mtd}
\title{Select dose by BOIN-COMB's MTD-choosing algorithm.}
\usage{
select_boin_comb_mtd(
  parent_selector_factory,
  when = c("finally", "always"),
  target = NULL,
  ...
)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{when}{Either of: 'finally' to select dose only when the parent
dose-selector has finished, by returning continue() == FALSE; or 'always'
to use this dose-selection algorithm for every dose decision. As per the
authors' original intentions, the default is 'finally'.}

\item{target}{We seek a dose with this probability of toxicity. If not
provided, the value will be sought from the parent dose-selector.}

\item{...}{Extra args are passed to \code{\link[BOIN]{select.mtd.comb}}.}
}
\value{
an object of type \code{\link{selector_factory}}.
}
\description{
Note: if you use this selector, it almost certainly needs to be the last
example in the chain - see Example below. This method selects dose by the
algorithm for identifying the maximum tolerable dose (MTD) described in Yan
et al. (2019). This class is intended to be used when a BOIN trial has
reached its maximum sample size. Thus, it intends to make the final dose
recommendation after the regular BOIN dose selection algorithm, as
implemented by \code{\link{get_boin}}, including any additional behaviours
that govern stopping (etc), has gracefully concluded a dose-finding trial.
However, the class can be used in any scenario where there is a target
toxicity rate. See Examples. Note - this class will not override the parent
dose selector when the parent is advocating no dose. Thus this class will not
reinstate a dangerous dose.
}
\examples{
# This class is intended to make the final dose selection in a BOIN-COMB
# trial:
# TODO

target <- 0.25
model <- get_boin(num_doses = 5, target = target) \%>\%
  stop_at_n(n = 12) \%>\%
  select_boin_mtd()

outcomes <- '1NNN 2NTN 2NNN 3NTT'
model \%>\% fit(outcomes) \%>\% recommended_dose()

# However, since behaviour is modular in this package, we can use this method
# to select dose at every dose decision if we wanted:
model2 <- get_boin(num_doses = 5, target = target) \%>\%
  select_boin_mtd(when = 'always')
model2 \%>\% fit('1NNT') \%>\% recommended_dose()
model2 \%>\% fit('1NNN 2NNT') \%>\% recommended_dose()

# and with any underlying model:
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
model3 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  select_boin_mtd(when = 'always')
model3 \%>\% fit('1NNT') \%>\% recommended_dose()
model3 \%>\% fit('1NNN 2NNT') \%>\% recommended_dose()

}
\references{
Yan, F., Pan, H., Zhang, L., Liu, S., & Yuan, Y. (2019). BOIN: An
  R Package for Designing Single-Agent and Drug-Combination Dose-Finding
  Trials Using Bayesian Optimal Interval Designs. Journal of Statistical
  Software, 27(November 2017), 0–35. https://doi.org/10.18637/jss.v094.i13
}
