
# This file is automatically generated, you probably don't want to edit this

jamoviproportionOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamoviproportionOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            switch = "from_raw",
            outcome_variable = NULL,
            cases = " ",
            not_cases = " ",
            case_label = "Affected",
            not_case_label = "Not Affected",
            outcome_variable_name = "My outcome variable",
            count_NA = FALSE,
            conf_level = 95,
            show_details = FALSE,
            plot_possible = FALSE,
            evaluate_hypotheses = FALSE,
            null_value = "0",
            null_boundary = "0",
            alpha = 0.05,
            null_color = "#A40122",
            es_plot_width = "300",
            es_plot_height = "400",
            ymin = "0",
            ymax = "1",
            breaks = "auto",
            ylab = "auto",
            xlab = "auto",
            axis.text.y = "14",
            axis.title.y = "15",
            axis.text.x = "14",
            axis.title.x = "15",
            error_layout = "none",
            shape_summary = "circle filled",
            color_summary = "#008DF9",
            fill_summary = "#008DF9",
            size_summary = "4",
            alpha_summary = "1",
            linetype_summary = "solid", ...) {

            super$initialize(
                package="esci",
                name="jamoviproportion",
                requiresData=TRUE,
                ...)

            private$..switch <- jmvcore::OptionList$new(
                "switch",
                switch,
                default="from_raw",
                options=list(
                    "from_raw",
                    "from_summary"))
            private$..outcome_variable <- jmvcore::OptionVariables$new(
                "outcome_variable",
                outcome_variable,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"))
            private$..cases <- jmvcore::OptionString$new(
                "cases",
                cases,
                default=" ")
            private$..not_cases <- jmvcore::OptionString$new(
                "not_cases",
                not_cases,
                default=" ")
            private$..case_label <- jmvcore::OptionString$new(
                "case_label",
                case_label,
                default="Affected")
            private$..not_case_label <- jmvcore::OptionString$new(
                "not_case_label",
                not_case_label,
                default="Not Affected")
            private$..outcome_variable_name <- jmvcore::OptionString$new(
                "outcome_variable_name",
                outcome_variable_name,
                default="My outcome variable")
            private$..count_NA <- jmvcore::OptionBool$new(
                "count_NA",
                count_NA,
                default=FALSE)
            private$..conf_level <- jmvcore::OptionNumber$new(
                "conf_level",
                conf_level,
                default=95)
            private$..show_details <- jmvcore::OptionBool$new(
                "show_details",
                show_details,
                default=FALSE)
            private$..plot_possible <- jmvcore::OptionBool$new(
                "plot_possible",
                plot_possible,
                default=FALSE)
            private$..evaluate_hypotheses <- jmvcore::OptionBool$new(
                "evaluate_hypotheses",
                evaluate_hypotheses,
                default=FALSE)
            private$..null_value <- jmvcore::OptionString$new(
                "null_value",
                null_value,
                default="0")
            private$..null_boundary <- jmvcore::OptionString$new(
                "null_boundary",
                null_boundary,
                default="0")
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                default=0.05)
            private$..null_color <- jmvcore::OptionList$new(
                "null_color",
                null_color,
                default="#A40122",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..es_plot_width <- jmvcore::OptionString$new(
                "es_plot_width",
                es_plot_width,
                default="300")
            private$..es_plot_height <- jmvcore::OptionString$new(
                "es_plot_height",
                es_plot_height,
                default="400")
            private$..ymin <- jmvcore::OptionString$new(
                "ymin",
                ymin,
                default="0")
            private$..ymax <- jmvcore::OptionString$new(
                "ymax",
                ymax,
                default="1")
            private$..breaks <- jmvcore::OptionString$new(
                "breaks",
                breaks,
                default="auto")
            private$..ylab <- jmvcore::OptionString$new(
                "ylab",
                ylab,
                default="auto")
            private$..xlab <- jmvcore::OptionString$new(
                "xlab",
                xlab,
                default="auto")
            private$..axis.text.y <- jmvcore::OptionString$new(
                "axis.text.y",
                axis.text.y,
                default="14")
            private$..axis.title.y <- jmvcore::OptionString$new(
                "axis.title.y",
                axis.title.y,
                default="15")
            private$..axis.text.x <- jmvcore::OptionString$new(
                "axis.text.x",
                axis.text.x,
                default="14")
            private$..axis.title.x <- jmvcore::OptionString$new(
                "axis.title.x",
                axis.title.x,
                default="15")
            private$..error_layout <- jmvcore::OptionList$new(
                "error_layout",
                error_layout,
                default="none",
                options=list(
                    "none"))
            private$..shape_summary <- jmvcore::OptionList$new(
                "shape_summary",
                shape_summary,
                default="circle filled",
                options=list(
                    "circle filled",
                    "square filled",
                    "triangle filled",
                    "diamond filled"))
            private$..color_summary <- jmvcore::OptionList$new(
                "color_summary",
                color_summary,
                default="#008DF9",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..fill_summary <- jmvcore::OptionList$new(
                "fill_summary",
                fill_summary,
                default="#008DF9",
                options=list(
                    "black",
                    "#00C2F9",
                    "#008DF9",
                    "#009F81",
                    "#FF5AAF",
                    "#9F0162",
                    "#A40122",
                    "#00FCCF",
                    "#FF6E3A",
                    "#FFB2FD",
                    "#8400CD",
                    "#E20134",
                    "#FFC33B",
                    "white",
                    "NA",
                    "NA",
                    "gray0",
                    "gray5",
                    "gray10",
                    "gray15",
                    "gray20",
                    "gray25",
                    "gray30",
                    "gray35",
                    "gray40",
                    "gray45",
                    "gray50",
                    "gray55",
                    "gray60",
                    "gray65",
                    "gray70",
                    "gray75",
                    "gray80",
                    "gray85",
                    "gray90",
                    "gray95",
                    "gray100"))
            private$..size_summary <- jmvcore::OptionList$new(
                "size_summary",
                size_summary,
                default="4",
                options=list(
                    "1",
                    "2",
                    "3",
                    "4",
                    "5",
                    "6"))
            private$..alpha_summary <- jmvcore::OptionList$new(
                "alpha_summary",
                alpha_summary,
                default="1",
                options=list(
                    "1",
                    ".75",
                    ".5",
                    ".25",
                    ".20",
                    ".15",
                    ".10",
                    ".05",
                    "0"))
            private$..linetype_summary <- jmvcore::OptionList$new(
                "linetype_summary",
                linetype_summary,
                default="solid",
                options=list(
                    "solid",
                    "dotted",
                    "dotdash",
                    "dashed",
                    "blank"))

            self$.addOption(private$..switch)
            self$.addOption(private$..outcome_variable)
            self$.addOption(private$..cases)
            self$.addOption(private$..not_cases)
            self$.addOption(private$..case_label)
            self$.addOption(private$..not_case_label)
            self$.addOption(private$..outcome_variable_name)
            self$.addOption(private$..count_NA)
            self$.addOption(private$..conf_level)
            self$.addOption(private$..show_details)
            self$.addOption(private$..plot_possible)
            self$.addOption(private$..evaluate_hypotheses)
            self$.addOption(private$..null_value)
            self$.addOption(private$..null_boundary)
            self$.addOption(private$..alpha)
            self$.addOption(private$..null_color)
            self$.addOption(private$..es_plot_width)
            self$.addOption(private$..es_plot_height)
            self$.addOption(private$..ymin)
            self$.addOption(private$..ymax)
            self$.addOption(private$..breaks)
            self$.addOption(private$..ylab)
            self$.addOption(private$..xlab)
            self$.addOption(private$..axis.text.y)
            self$.addOption(private$..axis.title.y)
            self$.addOption(private$..axis.text.x)
            self$.addOption(private$..axis.title.x)
            self$.addOption(private$..error_layout)
            self$.addOption(private$..shape_summary)
            self$.addOption(private$..color_summary)
            self$.addOption(private$..fill_summary)
            self$.addOption(private$..size_summary)
            self$.addOption(private$..alpha_summary)
            self$.addOption(private$..linetype_summary)
        }),
    active = list(
        switch = function() private$..switch$value,
        outcome_variable = function() private$..outcome_variable$value,
        cases = function() private$..cases$value,
        not_cases = function() private$..not_cases$value,
        case_label = function() private$..case_label$value,
        not_case_label = function() private$..not_case_label$value,
        outcome_variable_name = function() private$..outcome_variable_name$value,
        count_NA = function() private$..count_NA$value,
        conf_level = function() private$..conf_level$value,
        show_details = function() private$..show_details$value,
        plot_possible = function() private$..plot_possible$value,
        evaluate_hypotheses = function() private$..evaluate_hypotheses$value,
        null_value = function() private$..null_value$value,
        null_boundary = function() private$..null_boundary$value,
        alpha = function() private$..alpha$value,
        null_color = function() private$..null_color$value,
        es_plot_width = function() private$..es_plot_width$value,
        es_plot_height = function() private$..es_plot_height$value,
        ymin = function() private$..ymin$value,
        ymax = function() private$..ymax$value,
        breaks = function() private$..breaks$value,
        ylab = function() private$..ylab$value,
        xlab = function() private$..xlab$value,
        axis.text.y = function() private$..axis.text.y$value,
        axis.title.y = function() private$..axis.title.y$value,
        axis.text.x = function() private$..axis.text.x$value,
        axis.title.x = function() private$..axis.title.x$value,
        error_layout = function() private$..error_layout$value,
        shape_summary = function() private$..shape_summary$value,
        color_summary = function() private$..color_summary$value,
        fill_summary = function() private$..fill_summary$value,
        size_summary = function() private$..size_summary$value,
        alpha_summary = function() private$..alpha_summary$value,
        linetype_summary = function() private$..linetype_summary$value),
    private = list(
        ..switch = NA,
        ..outcome_variable = NA,
        ..cases = NA,
        ..not_cases = NA,
        ..case_label = NA,
        ..not_case_label = NA,
        ..outcome_variable_name = NA,
        ..count_NA = NA,
        ..conf_level = NA,
        ..show_details = NA,
        ..plot_possible = NA,
        ..evaluate_hypotheses = NA,
        ..null_value = NA,
        ..null_boundary = NA,
        ..alpha = NA,
        ..null_color = NA,
        ..es_plot_width = NA,
        ..es_plot_height = NA,
        ..ymin = NA,
        ..ymax = NA,
        ..breaks = NA,
        ..ylab = NA,
        ..xlab = NA,
        ..axis.text.y = NA,
        ..axis.title.y = NA,
        ..axis.text.x = NA,
        ..axis.title.x = NA,
        ..error_layout = NA,
        ..shape_summary = NA,
        ..color_summary = NA,
        ..fill_summary = NA,
        ..size_summary = NA,
        ..alpha_summary = NA,
        ..linetype_summary = NA)
)

jamoviproportionResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamoviproportionResults",
    inherit = jmvcore::Group,
    active = list(
        debug = function() private$.items[["debug"]],
        help = function() private$.items[["help"]],
        overview = function() private$.items[["overview"]],
        point_null = function() private$.items[["point_null"]],
        interval_null = function() private$.items[["interval_null"]],
        magnitude_plot_warnings = function() private$.items[["magnitude_plot_warnings"]],
        estimation_plots = function() private$.items[["estimation_plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Proportions: Single Group")
            self$add(jmvcore::Preformatted$new(
                options=options,
                name="debug",
                visible=TRUE))
            self$add(jmvcore::Html$new(
                options=options,
                name="help",
                visible=FALSE))
            self$add(jmvcore::Table$new(
                options=options,
                name="overview",
                title="Overview",
                rows=1,
                refs="prop1",
                clearWith=list(
                    "outcome_variable",
                    "cases",
                    "not_cases",
                    "case_label",
                    "not_case_label",
                    "outcome_variable_name",
                    "count_NA",
                    "conf_level",
                    "show_details"),
                columns=list(
                    list(
                        `name`="outcome_variable_name", 
                        `title`="Outcome variable", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="outcome_variable_level", 
                        `type`="text", 
                        `title`="Level"),
                    list(
                        `name`="cases", 
                        `title`="Cases", 
                        `type`="integer"),
                    list(
                        `name`="n", 
                        `title`="<i>N</i>", 
                        `type`="integer"),
                    list(
                        `name`="P", 
                        `title`="<i>P</i>", 
                        `type`="number"),
                    list(
                        `name`="P_LL", 
                        `title`="LL", 
                        `type`="number"),
                    list(
                        `name`="P_UL", 
                        `title`="UL", 
                        `type`="number"),
                    list(
                        `name`="P_SE", 
                        `type`="number", 
                        `title`="<i>SE</i><sub>Proportion</sub>", 
                        `visible`="(show_details)"),
                    list(
                        `name`="P_adjusted", 
                        `type`="number", 
                        `title`="<i>P</i><sub>adjusted</sub>", 
                        `visible`="(show_details)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="point_null",
                title="Hypothesis Evaluation",
                rows=1,
                visible="(evaluate_hypotheses & null_boundary == 0)",
                clearWith=list(
                    "outcome_variable",
                    "cases",
                    "not_cases",
                    "case_label",
                    "not_case_label",
                    "outcome_variable_name",
                    "count_NA",
                    "conf_level",
                    "show_details",
                    "null_value",
                    "null_boundary"),
                columns=list(
                    list(
                        `name`="effect_plus", 
                        `title`="Effect", 
                        `type`="text", 
                        `combineBelow`=FALSE),
                    list(
                        `name`="null_words", 
                        `title`="<i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="CI", 
                        `title`="CI", 
                        `type`="text"),
                    list(
                        `name`="CI_compare", 
                        `title`="Compare CI with <i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="t", 
                        `title`="<i>z</i>"),
                    list(
                        `name`="p", 
                        `title`="<i>p</i>, two tailed", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="null_decision", 
                        `title`="<i>H</i><sub>0</sub> decision"),
                    list(
                        `name`="conclusion", 
                        `title`="Conclusion", 
                        `type`="text"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="interval_null",
                title="Hypothesis Evaluation",
                rows=1,
                visible="(evaluate_hypotheses & null_boundary != 0)",
                clearWith=list(
                    "outcome_variable",
                    "cases",
                    "not_cases",
                    "case_label",
                    "not_case_label",
                    "outcome_variable_name",
                    "count_NA",
                    "conf_level",
                    "show_details",
                    "null_value",
                    "null_boundary"),
                columns=list(
                    list(
                        `name`="effect_plus", 
                        `title`="Effect", 
                        `type`="text", 
                        `combineBelow`=FALSE),
                    list(
                        `name`="rope", 
                        `title`="<i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="CI", 
                        `title`="CI", 
                        `type`="text"),
                    list(
                        `name`="rope_compare", 
                        `title`="Compare CI with <i>H</i><sub>0</sub>", 
                        `type`="text"),
                    list(
                        `name`="p_result", 
                        `title`="<i>p</i>, two tailed", 
                        `type`="text"),
                    list(
                        `name`="conclusion", 
                        `title`="Conclusion", 
                        `type`="text"))))
            self$add(jmvcore::Html$new(
                options=options,
                name="magnitude_plot_warnings",
                title="Figure Warnings",
                visible=TRUE))
            self$add(jmvcore::Array$new(
                options=options,
                name="estimation_plots",
                title="Estimation Figure",
                refs="ggdist",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    width=300,
                    height=450,
                    requiresData=TRUE,
                    renderFun=".estimation_plots")))}))

jamoviproportionBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jamoviproportionBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "esci",
                name = "jamoviproportion",
                version = c(1,0,0),
                options = options,
                results = jamoviproportionResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' Proportions: Single Group
#'
#' 
#' @param switch .
#' @param data .
#' @param outcome_variable .
#' @param cases .
#' @param not_cases .
#' @param case_label .
#' @param not_case_label .
#' @param outcome_variable_name .
#' @param count_NA .
#' @param conf_level .
#' @param show_details .
#' @param plot_possible .
#' @param evaluate_hypotheses .
#' @param null_value .
#' @param null_boundary .
#' @param alpha .
#' @param null_color .
#' @param es_plot_width .
#' @param es_plot_height .
#' @param ymin .
#' @param ymax .
#' @param breaks .
#' @param ylab .
#' @param xlab .
#' @param axis.text.y .
#' @param axis.title.y .
#' @param axis.text.x .
#' @param axis.title.x .
#' @param error_layout .
#' @param shape_summary .
#' @param color_summary .
#' @param fill_summary .
#' @param size_summary .
#' @param alpha_summary .
#' @param linetype_summary .
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$debug} \tab \tab \tab \tab \tab a preformatted \cr
#'   \code{results$help} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$overview} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$point_null} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$interval_null} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$magnitude_plot_warnings} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$estimation_plots} \tab \tab \tab \tab \tab an array of images \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$overview$asDF}
#'
#' \code{as.data.frame(results$overview)}
#'
#' @export
jamoviproportion <- function(
    switch = "from_raw",
    data,
    outcome_variable,
    cases = " ",
    not_cases = " ",
    case_label = "Affected",
    not_case_label = "Not Affected",
    outcome_variable_name = "My outcome variable",
    count_NA = FALSE,
    conf_level = 95,
    show_details = FALSE,
    plot_possible = FALSE,
    evaluate_hypotheses = FALSE,
    null_value = "0",
    null_boundary = "0",
    alpha = 0.05,
    null_color = "#A40122",
    es_plot_width = "300",
    es_plot_height = "400",
    ymin = "0",
    ymax = "1",
    breaks = "auto",
    ylab = "auto",
    xlab = "auto",
    axis.text.y = "14",
    axis.title.y = "15",
    axis.text.x = "14",
    axis.title.x = "15",
    error_layout = "none",
    shape_summary = "circle filled",
    color_summary = "#008DF9",
    fill_summary = "#008DF9",
    size_summary = "4",
    alpha_summary = "1",
    linetype_summary = "solid") {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("jamoviproportion requires jmvcore to be installed (restart may be required)")

    if ( ! missing(outcome_variable)) outcome_variable <- jmvcore::resolveQuo(jmvcore::enquo(outcome_variable))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(outcome_variable), outcome_variable, NULL))

    for (v in outcome_variable) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])

    options <- jamoviproportionOptions$new(
        switch = switch,
        outcome_variable = outcome_variable,
        cases = cases,
        not_cases = not_cases,
        case_label = case_label,
        not_case_label = not_case_label,
        outcome_variable_name = outcome_variable_name,
        count_NA = count_NA,
        conf_level = conf_level,
        show_details = show_details,
        plot_possible = plot_possible,
        evaluate_hypotheses = evaluate_hypotheses,
        null_value = null_value,
        null_boundary = null_boundary,
        alpha = alpha,
        null_color = null_color,
        es_plot_width = es_plot_width,
        es_plot_height = es_plot_height,
        ymin = ymin,
        ymax = ymax,
        breaks = breaks,
        ylab = ylab,
        xlab = xlab,
        axis.text.y = axis.text.y,
        axis.title.y = axis.title.y,
        axis.text.x = axis.text.x,
        axis.title.x = axis.title.x,
        error_layout = error_layout,
        shape_summary = shape_summary,
        color_summary = color_summary,
        fill_summary = fill_summary,
        size_summary = size_summary,
        alpha_summary = alpha_summary,
        linetype_summary = linetype_summary)

    analysis <- jamoviproportionClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

