% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shape.R
\name{add.shape}
\alias{add.shape}
\title{Adding shape to a 3D volume.}
\usage{
add.shape(obj, shape.bin, shape.mean, shape.sd)
}
\arguments{
\item{obj}{Object of the "volume" class and a modality other than "binary" or "weight".}

\item{shape.bin}{Object of the "volume" class and "binary" or "weight" modality,
sharing the same voxels as \code{obj}..}

\item{shape.mean, shape.sd}{Positive numbers, representing the mean value  and
the standard deviation of voxels identified by \code{shape.bin}.}
}
\value{
Returns the ‘volume’ class object \code{obj}, in which the voxels
identified by \code{shape.bin} have been replaced by a linear interpolation
between the initial value and new values. These new values follow a normal
distribution with mean \code{shape.mean} and standard deviation \code{shape.sd}.
The weights of the linear interpolation are defined by the voxels values of \code{shape.bin}.
}
\description{
The \code{add.shape} function adds the shape defined by espadon volume
object of the modality "binary" or "weight" to a 3D volume.
}
\examples{
# Creation of a volume
CT <- vol.create (c(80, 80,40), c(1.2, 1.2, 2), 
                  pt000 = c(-50.4,-50.4,-75), modality = "ct", 
                  default.value = as.integer(-997), value.sd = 1)
# Creation of a new shape shape                
ellipsoid <- bin.ellipsoid(CT, center = c(-20.1, 0.1, -15), 
                           radius =  c(19.3, 20.2, 15.3))  
                           
# Incorporating form into the CT
CT <- add.shape (CT, shape.bin = ellipsoid, shape.mean = 100, shape.sd = 10)

plot(CT, view.coord =  c(-20.1, 0.1, -15))      
}
\seealso{
\link[espadon]{bin.cuboid}, \link[espadon]{bin.cylinder}, \link[espadon]{bin.ellipsoid},
\link[espadon]{bin.from.roi}.
}
