% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_range.R
\name{mean_range}
\alias{mean_range}
\title{Calculate the mean within-event range across event reports for numeric variables}
\usage{
mean_range(data, group_var, variables)
}
\arguments{
\item{data}{A data frame containing event report level data.}

\item{group_var}{A character string naming the column that uniquely identifies events (e.g., "event_id").}

\item{variables}{A character vector of column names to compute ranges for. All specified variables must be numeric.}
}
\value{
A tibble with two columns:
\describe{
  \item{variable}{The name of each variable.}
  \item{mean_range}{The mean range across events for that variable.}
}
}
\description{
This function calculates the mean range for one or more numeric variables
grouped by an event identifier. It is useful for diagnosing aggregation sensitivity by
assessing how much spread exists in numeric values reported across event reports concerning
the same event.
}
\details{
For each variable and event, the function computes the range (i.e., the difference between
the maximum and minimum) of values reported across event reports. These values are then averaged
across all events to produce a single score per variable. The result is a long-format dataframe
that shows which numeric variables exhibit the widest event report level disagreement.
}
\examples{
df <- data.frame(
  event_id = c(1, 1, 2, 2, 3),
  deaths_best = c(10, 20, 5, 15, 10)
)
mean_range(
  df,
  group_var = "event_id",
  variables = c("deaths_best")
)
}
