% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm-ees1.R
\name{abm.ees1}
\alias{abm.ees1}
\title{EvoPER Evolutionary Strategy 1}
\usage{
abm.ees1(objective, options = NULL)
}
\arguments{
\item{objective}{An instance of ObjectiveFunction (or subclass) class \link{ObjectiveFunction}}

\item{options}{An apropiate instance from a sublclass of \link{Options} class}
}
\description{
This function tries to provide a rough approximation to
best solution when no information is available for the correct range
of input parameters for the objective function. It can useful for
studying the behavior of individual-based models with high
variability in the output variables showing nonlinear behaviors.
}
\examples{
\dontrun{
 f<- PlainFunction$new(f0.rosenbrock2)

 f$Parameter(name="x1",min=-100,max=100)
 f$Parameter(name="x2",min=-100,max=100)

 extremize("ees1", f)
}

}
