% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{unlab}
\alias{unlab}
\alias{drop_all_labels}
\title{Drop variable label and value labels}
\usage{
unlab(x)

drop_all_labels(x)
}
\arguments{
\item{x}{Variable(s). Vector/data.frame/list.}
}
\value{
\code{unlab} returns original variable x without variable label, value labels and class.
}
\description{
\code{unlab} returns variable x without variable labels and value labels
}
\examples{
raw_var = rep(1:2,5)
var_with_lab = set_var_lab(raw_var,"Income")
val_lab(var_with_lab) = c("Low"=1,"High"=2)
identical(raw_var,unlab(var_with_lab)) # should be TRUE
}
\seealso{
\code{\link{unvr}} \code{\link{unvl}}
}
