% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_from_ids.R
\name{txt_from_ids}
\alias{txt_from_ids}
\title{Get a descriptive text from a series of id codes}
\usage{
txt_from_ids(
  id_list,
  type = "sec",
  lang = "en",
  ver = "short",
  wiotype = "icio2023"
)
}
\arguments{
\item{id_list}{String or string vector of ids (in rows, columns, etc)}

\item{type}{Type of id: \code{"sec"} for sector ids, \code{"geo"} for country or
country group ids, \code{"va"} for value-added component ids.}

\item{lang}{Character string for the language of the descriptive text:
\code{"eng"} for English (default) and \code{"es"} for Spanish.}

\item{ver}{Version: \code{"short"} (default) or \code{"long"}.}

\item{wiotype}{Type of \code{wio} (which determines the codes and text)}
}
\value{
A string vector with text
}
\description{
Gives a descriptive text of id codes from a vector of id codes, like
those in rows or columns of \code{exvatools} objects.
}
\examples{
txt_from_ids("MANUF")
txt_from_ids("MANUF", lang = "es")
}
