% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabregCI.R
\name{fabregCI}
\alias{fabregCI}
\title{FAB regression coefficient intervals}
\usage{
fabregCI(
  y,
  X,
  alpha = 0.05,
  dof = min(50, round(0.5 * (dim(X)[1] - dim(X)[2]))),
  verbose = TRUE
)
}
\arguments{
\item{y}{a numeric vector of data}

\item{X}{a design matrix}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}

\item{dof}{degrees of freedom to use for the t-quantiles (the remainder 
go to adaptive estimation of the prior)}

\item{verbose}{logical, print progress or not}
}
\value{
A matrix where each row corresponds to the interval and OLS 
estimate of a coefficient.
}
\description{
Compute the adaptive FAB t-intervals for the 
coefficients of a regression model.
}
\details{
This function computes the adaptive FAB 
confidence interval for each coefficient in 
a linear regression model.
}
\author{
Peter Hoff
}
