% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate.mdl_df}
\alias{interpolate.mdl_df}
\alias{interpolate.mdl_ts}
\title{Interpolate missing values}
\usage{
\method{interpolate}{mdl_df}(object, new_data, ...)

\method{interpolate}{mdl_ts}(object, new_data, ...)
}
\arguments{
\item{object}{A mable containing a single model column.}

\item{new_data}{A dataset with the same structure as the data used to fit the model.}

\item{...}{Other arguments passed to interpolate methods.}
}
\description{
Uses a fitted model to interpolate missing values from a dataset.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(fable)
library(tsibbledata)

# The fastest running times for the olympics are missing for years during 
# world wars as the olympics were not held.
olympic_running

olympic_running \%>\% 
  model(TSLM(Time ~ trend())) \%>\% 
  interpolate(olympic_running)
\dontshow{\}) # examplesIf}
}
