% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{interpolate.FASSTER}
\alias{interpolate.FASSTER}
\title{Interpolate missing values in a FASSTER model}
\usage{
\method{interpolate}{FASSTER}(object, new_data, specials, ...)
}
\arguments{
\item{object}{A fitted FASSTER model object.}

\item{new_data}{A tsibble containing the data to interpolate. Must be the
same data used to fit the model.}

\item{specials}{A list of special terms (passed by fabletools).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tsibble with missing values in the response variable replaced by
fitted values.
}
\description{
Fills in missing values in the response variable using the model's fitted
values. This method only works for interpolating data used to estimate the
model and cannot be used for new data.
}
\details{
This method identifies missing values (NAs) in the response variable and
replaces them with the corresponding fitted values from the model. It only
works when \code{new_data} has the same length as the data used to fit the model.
}
\examples{
library(tsibble)
library(dplyr)

# Create data with missing values
deaths_na <- as_tsibble(mdeaths) |>
  mutate(value = if_else(row_number() \%in\% c(10, 20, 30), NA_real_, value))

# Fit model
fit <- deaths_na |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Interpolate missing values
interpolate(fit, deaths_na)

}
