% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_fitted}
\alias{qr_fitted}
\title{Compute fitted values from a QR decomposition}
\usage{
qr_fitted(qr, tau, y)
}
\arguments{
\item{qr}{Numeric matrix containing the QR decomposition of \eqn{X}
in compact form (as returned by \code{qr_fast()}).}

\item{tau}{numeric vector of Householder coefficients.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector of fitted values \eqn{\hat y}.
}
\description{
Computes the fitted values \eqn{\widehat y = X\widehat\beta} for a linear
least-squares problem using a QR decomposition stored in compact
(Householder) form.
}
\details{
The fitted values are computed as
\deqn{\widehat y = Q Q^\top y}
without explicitly forming the orthogonal matrix \eqn{Q}. The
computation relies on the Householder reflectors stored in
\code{qr} and \code{tau}.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

qr_res <- fastQR::qr_fast(X)
yhat1  <- fastQR::qr_fitted(qr = qr_res$qr, tau = qr_res$qraux, y = y)

## reference computation
yhat2 <- base::qr.fitted(base::qr(X), y)

max(abs(yhat1 - yhat2))

}
