% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_lse_Qy}
\alias{qr_lse_Qy}
\title{Compute Qy for a least-squares problem}
\usage{
qr_lse_Qy(X, y)
}
\arguments{
\item{X}{numeric matrix of dimension \eqn{n \times p}.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector equal to \eqn{Q y}.
}
\description{
Computes the product \eqn{Q y}, where \eqn{Q} is the orthogonal
matrix from the QR decomposition of the design matrix \eqn{X}.
}
\details{
The QR decomposition of \eqn{X} is computed internally, and the
orthogonal matrix \eqn{Q} is never formed explicitly. The product
\eqn{Q y} is evaluated efficiently using Householder reflectors.

This function is intended as a convenience wrapper for least-squares
computations when the explicit QR factors are not required.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

res1 <- fastQR::qr_lse_Qy(X, y)

## reference computation
res2 <- base::qr.Q(base::qr(X), complete = TRUE) \%*\% y

max(abs(res1 - drop(res2)))

}
