% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_lime.R
\name{explain_lime}
\alias{explain_lime}
\title{Generate LIME explanations for a fastml model}
\usage{
explain_lime(
  object,
  new_observation,
  data = c("train", "test"),
  n_features = 5,
  n_labels = 1,
  ...
)
}
\arguments{
\item{object}{A `fastml` object.}

\item{new_observation}{A data frame containing the new observation(s) to explain.
Must contain the same columns as the original training data (before preprocessing).
The function will apply the stored preprocessor to transform it.}

\item{data}{Character string specifying which data to use for the LIME explainer background:
\code{"train"} (default) or \code{"test"}.}

\item{n_features}{Number of features to show in the explanation. Default 5.}

\item{n_labels}{Number of labels to explain (classification only). Default 1.}

\item{...}{Additional arguments passed to `lime::explain`.}
}
\value{
An object produced by `lime::explain`.
}
\description{
Creates a `lime` explainer using processed (encoded, scaled) data and returns
feature explanations for new observations. The new observation is automatically
preprocessed using the same recipe to ensure alignment with the explainer background.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
explain_lime(model, new_observation = iris[1, ])
}
}
