% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implication_set.R
\name{ImplicationSet}
\alias{ImplicationSet}
\title{R6 class for an Implication Set}
\description{
This class implements an implication set (LHS -> RHS) in the framework of
Formal Concept Analysis (FCA). It inherits from \code{RuleSet} and adds
FCA-specific methods such as closure computation, simplification, and
basis transformation.
}
\section{Super class}{
\code{\link[fcaR:RuleSet]{fcaR::RuleSet}} -> \code{ImplicationSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ImplicationSet-new}{\code{ImplicationSet$new()}}
\item \href{#method-ImplicationSet-add}{\code{ImplicationSet$add()}}
\item \href{#method-ImplicationSet-to_arules}{\code{ImplicationSet$to_arules()}}
\item \href{#method-ImplicationSet-print}{\code{ImplicationSet$print()}}
\item \href{#method-ImplicationSet-support}{\code{ImplicationSet$support()}}
\item \href{#method-ImplicationSet-closure}{\code{ImplicationSet$closure()}}
\item \href{#method-ImplicationSet-recommend}{\code{ImplicationSet$recommend()}}
\item \href{#method-ImplicationSet-apply_rules}{\code{ImplicationSet$apply_rules()}}
\item \href{#method-ImplicationSet-to_basis}{\code{ImplicationSet$to_basis()}}
\item \href{#method-ImplicationSet-to_direct_optimal}{\code{ImplicationSet$to_direct_optimal()}}
\item \href{#method-ImplicationSet-use_logic}{\code{ImplicationSet$use_logic()}}
\item \href{#method-ImplicationSet-get_logic}{\code{ImplicationSet$get_logic()}}
\item \href{#method-ImplicationSet-use_hedge}{\code{ImplicationSet$use_hedge()}}
\item \href{#method-ImplicationSet-get_hedge}{\code{ImplicationSet$get_hedge()}}
\item \href{#method-ImplicationSet-to_json}{\code{ImplicationSet$to_json()}}
\item \href{#method-ImplicationSet-clone}{\code{ImplicationSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="["><a href='../../fcaR/html/RuleSet.html#method-RuleSet-bracket'><code>fcaR::RuleSet$[()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="cardinality"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-cardinality'><code>fcaR::RuleSet$cardinality()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="confidence"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-confidence'><code>fcaR::RuleSet$confidence()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="filter"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-filter'><code>fcaR::RuleSet$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="get_LHS_matrix"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-get_LHS_matrix'><code>fcaR::RuleSet$get_LHS_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="get_RHS_matrix"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-get_RHS_matrix'><code>fcaR::RuleSet$get_RHS_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="get_attributes"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-get_attributes'><code>fcaR::RuleSet$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="get_implications"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-get_implications'><code>fcaR::RuleSet$get_implications()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="get_quality"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-get_quality'><code>fcaR::RuleSet$get_quality()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="is_empty"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-is_empty'><code>fcaR::RuleSet$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="size"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-size'><code>fcaR::RuleSet$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="RuleSet" data-id="to_latex"><a href='../../fcaR/html/RuleSet.html#method-RuleSet-to_latex'><code>fcaR::RuleSet$to_latex()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-new}{}}}
\subsection{Method \code{new()}}{
Initialize an ImplicationSet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A \code{rules} object (from \code{arules}) or named arguments:
\code{name} (string), \code{attributes} (character vector),
\code{lhs} and \code{rhs} (sparse matrices), \code{I} (incidence matrix).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImplicationSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-add"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-add}{}}}
\subsection{Method \code{add()}}{
Add a precomputed implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{An \code{ImplicationSet} object, a \code{rules} object, or a pair \code{lhs}, \code{rhs} of \code{Set} objects or \code{dgCMatrix}. The implications to add to this formal context.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, just updates the internal \code{implications} field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_arules"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_arules}{}}}
\subsection{Method \code{to_arules()}}{
Convert to arules format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_arules(quality = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quality}}{(logical) Compute the interest measures for each rule?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{rules} object as used by package \code{arules}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-print}{}}}
\subsection{Method \code{print()}}{
Print all implications to text
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with all the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-support"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-support}{}}}
\subsection{Method \code{support()}}{
Compute support of each implication
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each implication
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-closure"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-closure}{}}}
\subsection{Method \code{closure()}}{
Compute the semantic closure of a fuzzy set with respect to the implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$closure(S, reduce = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a \code{Set} object)  Fuzzy set to compute its closure. Use class \code{Set} to build it.}

\item{\code{reduce}}{(logical) Reduce the implications using simplification logic?}

\item{\code{verbose}}{(logical) Show verbose output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{reduce == FALSE}, the output is a fuzzy set corresponding to the closure of \code{S}. If \code{reduce == TRUE}, a list with two components: \code{closure}, with the closure as above, and \code{implications}, the reduced set of implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-recommend"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-recommend}{}}}
\subsection{Method \code{recommend()}}{
Generate a recommendation for a subset of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$recommend(S, attribute_filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a vector) Vector with the grades of each attribute (a fuzzy set).}

\item{\code{attribute_filter}}{(character vector) Names of the attributes to get recommendation for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A fuzzy set describing the values of the attributes in \code{attribute_filter} within the closure of \code{S}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-apply_rules"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-apply_rules}{}}}
\subsection{Method \code{apply_rules()}}{
Apply rules to remove redundancies
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$apply_rules(
  rules = c("composition", "generalization"),
  batch_size = 25000L,
  parallelize = FALSE,
  reorder = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rules}}{(character vector) Names of the rules to use. See \code{details}.}

\item{\code{batch_size}}{(integer) If the number of rules is large, apply the rules by batches of this size.}

\item{\code{parallelize}}{(logical) If possible, should we parallelize the computation among different batches?}

\item{\code{reorder}}{(logical) Should the rules be randomly reordered previous to the computation?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Currently, the implemented rules are \code{"generalization"}, \code{"simplification"}, \code{"reduction"} and \code{"composition"}.
}

\subsection{Returns}{
Nothing, just updates the internal matrices for LHS and RHS.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_basis}{}}}
\subsection{Method \code{to_basis()}}{
Convert Implications to Canonical Basis
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The canonical basis of implications obtained from the current \code{ImplicationSet}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_direct_optimal"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_direct_optimal}{}}}
\subsection{Method \code{to_direct_optimal()}}{
Compute the Direct Optimal Basis using optimized C++ algorithms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_direct_optimal(
  method = c("do_sp", "direct_optimal", "final_ts", "monotonic", "priority"),
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{(character) The specific algorithm to run:
\itemize{
\item \code{"direct_optimal"}: (Default) The Direct Optimal Saturation-Pruning algorithm.
\item \code{"final_ts"}: Computes Transitive Closure then Prunes (Standard approach).
\item \code{"monotonic"}: Incremental algorithm maintaining monotonicity.
\item \code{"priority"}: Priority-based refinement algorithm.
}}

\item{\code{verbose}}{(logical) Print verbose output from the C++ backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, updates the \code{ImplicationSet} in place with the new basis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-use_logic"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-use_logic}{}}}
\subsection{Method \code{use_logic()}}{
Sets the logic to use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$use_logic(name = available_logics())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the logic to use. To see the available names, run \code{available_logics()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_logic"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_logic}{}}}
\subsection{Method \code{get_logic()}}{
Gets the logic used
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_logic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the name of the logic.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-use_hedge"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-use_hedge}{}}}
\subsection{Method \code{use_hedge()}}{
Sets the hedge to use when computing closures
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$use_hedge(name = c("globalization", "identity"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the hedge to use. Only "globalization" and "identity" are allowed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-get_hedge"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-get_hedge}{}}}
\subsection{Method \code{get_hedge()}}{
Gets the hedge used to compute closures
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_hedge()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the name of the hedge
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-to_json"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-to_json}{}}}
\subsection{Method \code{to_json()}}{
Export the implication set to JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_json(file = NULL, return_list = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) The path of the file to save the JSON to.}

\item{\code{return_list}}{(logical) If TRUE, returns the list representation instead of the JSON string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A JSON string representing the implication set, or a list if \code{return_list} is TRUE.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImplicationSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ImplicationSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
