% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{get_l2_norm}
\alias{get_l2_norm}
\title{Computes the \eqn{L^2} norm of an SRVF}
\usage{
get_l2_norm(qfun)
}
\arguments{
\item{qfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the SRVF at \eqn{s}.}
}
\value{
A numeric value storing the \eqn{L^2} norm of the SRVF.
}
\description{
Computes the \eqn{L^2} norm of an SRVF
}
\examples{
q <- curve2srvf(beta[, , 1, 1])
get_l2_norm(q)
}
