% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_SVDimpute.R
\name{fill.SVDimpute}
\alias{fill.SVDimpute}
\title{Iterative Regression against Right Singular Vectors}
\usage{
fill.SVDimpute(A, k = ceiling(ncol(A)/2), maxiter = 100, tol = 0.01)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{k}{the number of regressors to be used.}

\item{maxiter}{maximum number of iterations to be performed.}

\item{tol}{stopping criterion for an incremental progress.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} matrix after completion.}
}
}
\description{
Singular Value Decomposition (SVD) is the best low-rank approximation of a given matrix.
\code{fill.SVDimpute} exploits such idea. First, it starts with simple filling using
column mean values for filling. Second, it finds SVD of a current matrix. Then,
each row vector is regressed upon top-\eqn{k} right singular vectors. Missing entries are
then filled with predicted estimates.
}
\examples{
\dontrun{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
set.seed(5)
A <- aux.rndmissing(lena128, x=0.05)

## apply the method with 3 different number of regressors
fill1 <- fill.SVDimpute(A, k=5)
fill2 <- fill.SVDimpute(A, k=25)
fill3 <- fill.SVDimpute(A, k=50)

## visualize only the last ones from each run
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill1$X, col=gray((0:100)/100), axes=FALSE, main="5 regressors")
image(fill2$X, col=gray((0:100)/100), axes=FALSE, main="25 regressors")
image(fill3$X, col=gray((0:100)/100), axes=FALSE, main="50 regressors")
par(opar)
}


}
\references{
\insertRef{troyanskaya_missing_2001}{filling}
}
\seealso{
\code{\link{fill.KNNimpute}}
}
