% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{africa_network}
\alias{africa_network}
\title{Trans-African Road Transport Network}
\format{
A Simple feature collection (sf object) with 2,825 LINESTRING features and 28 fields:
\describe{
  \item{from}{Integer. Origin node index (1 to 1,377).}
  \item{to}{Integer. Destination node index (2 to 1,379).}
  \item{from_ctry}{Character. Origin country ISO3 code (49 countries).}
  \item{to_ctry}{Character. Destination country ISO3 code (49 countries).}
  \item{FX}{Numeric. Origin node longitude.}
  \item{FY}{Numeric. Origin node latitude.}
  \item{TX}{Numeric. Destination node longitude.}
  \item{TY}{Numeric. Destination node latitude.}
  \item{sp_distance}{Numeric. Spherical (great-circle) distance in meters.}
  \item{distance}{Numeric. Road distance in meters from OSRM routing.}
  \item{duration}{Numeric. Travel duration in minutes from OSRM routing (NA for proposed links).}
  \item{speed_kmh}{Numeric. Average speed in km/h (distance/duration) (NA for proposed links).}
  \item{passes}{Numeric. Number of optimal inter-city routes passing through this edge (NA for proposed links).}
  \item{gravity}{Numeric. Sum of population gravity weights from routes using this edge (NA for proposed links).}
  \item{gravity_rd}{Numeric. Sum of road-distance-weighted gravity from routes (NA for proposed links).}
  \item{border_dist}{Numeric. Additional distance for border crossing in meters (0 for domestic links).}
  \item{total_dist}{Numeric. Total distance including border crossing penalty in meters.}
  \item{border_time}{Numeric. Additional time for border crossing in minutes.}
  \item{total_time}{Numeric. Total travel time including border crossing in minutes.}
  \item{duration_100kmh}{Numeric. Hypothetical travel time at 100 km/h in minutes.}
  \item{total_time_100kmh}{Numeric. Hypothetical total time at 100 km/h including border penalties.}
  \item{rugg}{Numeric. Terrain ruggedness index along the edge.}
  \item{pop_wpop}{Numeric. Population within corridor (WorldPop data).}
  \item{pop_wpop_km2}{Numeric. Population density per km2 along corridor.}
  \item{cost_km}{Numeric. Estimated road construction/maintenance cost per km in USD.}
  \item{upgrade_cat}{Character. Road upgrade category: "Nothing", "Asphalt Mix Resurfacing", "Mixed Works", "Upgrade", or NA.}
  \item{ug_cost_km}{Numeric. Upgrade cost per km in USD.}
  \item{add}{Logical. TRUE for proposed new links, FALSE for existing road network edges.}
  \item{geometry}{LINESTRING. Spatial geometry in WGS 84 (EPSG:4326) coordinate reference system.}
}
}
\source{
Road network derived from OpenStreetMap via OSRM routing.
Border crossing data from World Bank estimates.
Terrain data from SRTM elevation models.
Population data from WorldPop.

Dataset constructed for: Krantz, S. (2024). Optimal Investments in Africa's Road Network.
Policy Research Working Paper 10893. World Bank. \doi{10.1596/1813-9450-10893}.
Replication materials: \url{https://github.com/SebKrantz/OptimalAfricanRoads}.
}
\usage{
data(africa_network)
}
\description{
A spatial dataset representing a discretized road transport network connecting major African cities
and ports. The network combines existing road infrastructure (2,344 edges) with proposed new links
(481 edges) identified through network efficiency analysis. Each edge contains distance, travel time,
border crossing costs, terrain characteristics, and road upgrade cost estimates.
}
\details{
The network was constructed through the following process:
\enumerate{
  \item Computing optimal routes between all city pairs within 2,000km using OSRM
  \item Filtering routes using network efficiency criteria (alpha = 45 degrees, EU-grade efficiency)
  \item Intersecting and aggregating overlapping route segments
  \item Contracting the network to reduce complexity while preserving connectivity
  \item Identifying proposed new links that would improve network route efficiency
  \item Adding border crossing costs based on country pairs
  \item Computing terrain, population, and road cost attributes
}

The \code{gravity} and \code{gravity_rd} fields measure edge importance based on the population
gravity model: routes between larger, closer cities contribute more weight to edges they traverse.

The bounding box spans continental Africa from approximately 34S to 37N latitude
and 17W to 49E longitude.
}
\examples{
library(sf)
data(africa_network)
head(africa_network)

# Existing vs proposed links
table(africa_network$add)

# Cross-border links
cross_border <- africa_network[africa_network$from_ctry != africa_network$to_ctry, ]
nrow(cross_border)

# Upgrade categories
table(africa_network$upgrade_cat, useNA = "ifany")

\donttest{
# Plot by gravity
plot(africa_network["gravity_rd"])

# Highlight proposed new links
plot(africa_network[africa_network$add, "geometry"], col = "red", add = TRUE)
}

}
\seealso{
\code{\link{africa_cities_ports}}, \code{\link{africa_segments}},
  \code{\link{africa_trade}}, \link{flownet-package}
}
\keyword{datasets}
