% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dtmax.R
\name{calc_dtmax_mw_dr}
\alias{calc_dtmax_mw_dr}
\title{Calculate dTmax by the moving window and double regression methods}
\usage{
calc_dtmax_mw_dr(
  vctr_time_daily = NULL,
  vctr_dtmax_pd = NULL,
  wndw_size_dtmax = 11,
  min_n_wndw_dtmax = 3,
  output_daily = FALSE,
  vctr_time = NULL,
  vctr_dt = NULL,
  vctr_radi = NULL,
  thres_radi = 100,
  thres_hour_pd = 8
)
}
\arguments{
\item{vctr_time_daily}{A timestamp vector of class POSIXct or POSIXt in
daily steps. This vector indicates the start and end dates of the
measurement, and is assumed to be output from the `calc_dtmax_pd()`
function. The timestamps must be equally spaced and arranged
chronologically. If this argument is `NULL` (default), `vctr_time`,
`vctr_dt`, and `vctr_radi` must be provided to conduct the daily predawn
method previously.}

\item{vctr_dtmax_pd}{A vector of dTmax estimated by the daily predawn method
in daily steps. This vector is assumed to be output from the
`calc_dtmax_pd()` function. The length of the vector must match that of the
`vctr_time_daily`. If this argument is `NULL` (default), `vctr_time`,
`vctr_dt`, and `vctr_radi` must be provided to conduct the daily predawn
method previously.}

\item{wndw_size_dtmax}{A positive integer indicating the window size (days)
for determining moving window maximum values of dTmax. Default is 11
(days).}

\item{min_n_wndw_dtmax}{A positive integer indicating the minimum number of
data points for calculating statistics using a moving window (default is
3). If the number of data points is less than this threshold, the
statistics are not calculated in the window.}

\item{output_daily}{A boolean. If `TRUE`, returns dTmax time series in daily
steps; else, returns dTmax in the original time steps. Default is `FALSE`.}

\item{vctr_time}{Only valid when `vctr_dtmax_pd` is `NULL`. A timestamp
vector of class POSIXct or POSIXt. This vector indicates the timings of the
end of each measurement in local time. Any interval (typically 15 to 60
min) is allowed, but the timestamps must be equally spaced and arranged
chronologically. Default is `NULL`.}

\item{vctr_dt}{Only valid when `vctr_dtmax_pd` is `NULL`. A vector of dT
(the temperature difference between sap flow probes, in degrees Celsius)
time series. The length of the vector must match that of the `vctr_time`.
Missing values must be gap-filled previously. Default is `NULL`.}

\item{vctr_radi}{Only valid when `vctr_dtmax_pd` is `NULL`. A vector of
global solar radiation or a similar radiative variable time series. The
length of the vector must match that of the `vctr_time`. Missing values
must be gap-filled previously. The unit of the time series must match that
of `thres_radi`. Default is `NULL`.}

\item{thres_radi}{A threshold value of the radiation to define daytime.
Default is 100 (W m-2). The data points with radiation values above the
threshold are considered daytime values. The unit of the threshold must
match that of the input radiation time series.}

\item{thres_hour_pd}{An integer from 0 to 23. The threshold hour of the day
which defines the end of predawn in local time (default is 8).}
}
\description{
`calc_dtmax_mw_dr()` calculates the time series of dTmax (the
 maximum temperature difference between sap flow probes under zero-flow
 conditions) using the moving window and the double regression methods.
}
\author{
Yoshiaki Hata
}
\keyword{internal}
