% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek-guess-encoding.R
\name{peek_guess_encoding}
\alias{peek_guess_encoding}
\title{Guess File Encoding}
\usage{
peek_guess_encoding(path)
}
\arguments{
\item{path}{path to the text file.}
}
\value{
a character string giving the most likely encoding.
}
\description{
Detect the encoding of a text file. This function is a
wrapper around \code{\link[readr]{guess_encoding}} from
the \code{readr} package, returning the best candidate
as a character string.

\code{readr} must be installed (it is listed in \code{Suggests}).
If it is not available, the function stops with an informative
message.
}
\examples{
\dontrun{
f <- system.file(package = "fpeek",
  "datafiles", "cigfou-ISO-8859-1.txt")
peek_guess_encoding(f)
}
}
