% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Initialize a froggeR Project from the Template}
\usage{
init(path = here::here())
}
\arguments{
\item{path}{Character. Directory where the project will be created. If the
directory does not exist, it will be created. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the normalized \code{path}.
}
\description{
Downloads the latest project scaffold from the
\href{https://github.com/kyleGrealis/frogger-templates}{frogger-templates}
repository and restores any saved user configuration. This is the
recommended way to start a new froggeR project.
}
\details{
The function performs these steps:
\enumerate{
  \item Creates the target directory if it does not exist
  \item Downloads the latest template zip from GitHub
  \item Copies only files that do not already exist (never overwrites)
  \item Restores saved user config (\code{_variables.yml}, \code{_brand.yml},
    \code{logos/}) from \code{~/.config/froggeR/} if present
  \item Creates a \code{data/} directory (gitignored by default)
}

Existing files are never overwritten. Each created and skipped file is
reported individually so you can see exactly what changed.

Global configuration is saved via \code{\link{save_variables}} and
\code{\link{save_brand}}. If no saved config exists, the template defaults
are used as-is.
}
\examples{
\dontrun{
# Create a new project (directory is created automatically)
init(path = file.path(tempdir(), "my-project"))
}

}
\seealso{
\code{\link{write_variables}}, \code{\link{write_brand}},
  \code{\link{save_variables}}, \code{\link{save_brand}}
}
