% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrcc.R
\name{mixregfit_multivariate}
\alias{mixregfit_multivariate}
\title{Performs the estimation of gaussian mixtures of regression models and gaussian mixture models.
Used in FMRCC_PhaseI.}
\usage{
mixregfit_multivariate(
  y,
  x,
  k,
  init_met = "random",
  intercept = FALSE,
  eps = 1e-06,
  max_iter = 500,
  model_Sigma
)
}
\arguments{
\item{y}{a matrix with the scores of the response variable}

\item{x}{a matrix with the scores of the covariates}

\item{k}{the number of groups to consider in the model estimation}

\item{init_met}{the method to initialize the model, it can be 'kmeans' or 'random'. Default is 'kmeans'}

\item{intercept}{logical, if TRUE the model includes an intercept. Default is TRUE}

\item{eps}{the convergence criterion. Default is 1e-6}

\item{max_iter}{the maximum number of iterations. Default is 500}

\item{model_Sigma}{the parametrization of the covariance. It can be 'VVV', 'EEE', 'VII' or 'EII', with no default}
}
\value{
a list with the estimated parameters of the model
}
\description{
Performs the estimation of gaussian mixtures of regression models and gaussian mixture models.
Used in FMRCC_PhaseI.
}
