% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoMFCC_PhaseI_casewise}
\alias{RoMFCC_PhaseI_casewise}
\title{Robust Multivariate Functional Control Charts - Phase I (casewise version)}
\usage{
RoMFCC_PhaseI_casewise(
  mfdobj_imp,
  mfdobj_imp_tuning,
  pca_par = list(fev = 0.7),
  alpha_casewise = 0.0027,
  verbose = FALSE
)
}
\arguments{
\item{mfdobj_imp}{A multivariate functional data object of class \code{mfd}, already imputed
and filtered, so with no cellwise outliers.
A robust multivariate principal component functional analysis
is applied to the imputed dataset for dimension reduction.}

\item{mfdobj_imp_tuning}{An additional functional data object of class \code{mfd}, already imputed
and filtered, so with no cellwise outliers.
It is used to robustly estimate the distribution of the Hotelling's T2 and
SPE statistics in order to calculate control limits
to prevent overfitting issues that could reduce the
monitoring performance of the RoMFCC.}

\item{pca_par}{A list with an argument \code{fev}, indicating a number between 0 and 1
denoting the fraction of variability that must be explained by the
principal components to be selected in the RoMFPCA step.
All the other arguments of this list are passed as arguments to the function
\code{rpca_mfd} in the RoMFPCA step.
All the arguments that are not passed take their default values.
See \code{\link{rpca_mfd}} for all the arguments and their default
values.
Default value is \code{list(fev = 0.7)}.}

\item{alpha_casewise}{The overall nominal type-I error probability used to set
control chart limits and to identify functional casewise outliers
Default value is 0.0027.}

\item{verbose}{If TRUE, it prints messages about the steps of the algorithm.
Default is FALSE.}
}
\value{
A list of the following elements that are needed in Phase II:
\itemize{
\item \code{T2} the Hotelling's T2 statistic values for the Phase I data set,
\item \code{SPE} the SPE statistic values for the Phase I data set,
\item \code{T2_tun} the Hotelling's T2 statistic values for the tuning data set,
\item \code{SPE_tun} the SPE statistic values for the tuning data set,
\item \code{T2_lim} the Phase II control limit of
the Hotelling's T2 control chart,
\item \code{spe_lim} the Phase II control limit of
the SPE control chart,
\item \code{mod_pca} the final RoMFPCA model fitted on the Phase I data set,
\item \code{K} = K the number of selected principal components,
\item \code{T_T2_inv} if a tuning data set is provided,
it returns the inverse of the covariance matrix
of the first \code{K} scores, needed to calculate the Hotelling's T2
statistic for the Phase II observations.
\item \code{mean_scores_tuning_rob_mean} if a tuning data set is provided,
it returns the robust location estimate of the scores, needed to calculate
the Hotelling's T2 and SPE
statistics for the Phase II observations.
}
}
\description{
It performs Phase I of the Robust Multivariate Functional Control Chart
(RoMFCC), proposed by Capezza et al. (2024), applied to casewise outlier
detection.
}
\details{
Unlike the original RoMFCC implementation, this version assumes that:
\itemize{
\item functional filter
\item robust multivariate functional imputation
have already been applied to the training and tuning datasets.
Therefore, the input data are expected to be multivariate functional
data free of cellwise outliers (casewise outliers may still be present).
}
}
\examples{
\dontrun{
library(funcharts)
set.seed(0)
dat <- simulate_data_RoMFCC(p_cellwise = 0.05,
                            p_casewise = 0.05,
                            outlier = "outlier_E",
                            M_outlier_cell = 0.03,
                            M_outlier_case = 0.01,
                            max_n_cellwise = 10)
mfdobj <- get_mfd_list(dat$X_mat_list, n_basis = 5)
mfdobj_training <- mfdobj[1:333, ]
mfdobj_tuning <- mfdobj[334:1000, ]
ff_training <- functional_filter(mfdobj = mfdobj_training)
ff_tuning <- functional_filter(mfdobj = mfdobj_tuning)
x_imp_training <- RoMFDI(mfdobj = ff_training$mfdobj)
x_imp_tuning <- RoMFDI(mfdobj = ff_tuning$mfdobj)
X_imp_training <- x_imp_training[[1]]
X_imp_tuning <- x_imp_tuning[[1]]
out_phase1_casewise <- RoMFCC_PhaseI_casewise(
  mfdobj_imp = X_imp_training,
  mfdobj_imp_tuning = X_imp_tuning
)
mfd_all_imputed <- rbind_mfd(X_imp_training, X_imp_tuning)
out_phase2_casewise <- RoMFCC_PhaseII_casewise(
  mfdobj_all_imp = mfdobj_all_imputed,
  mod_phaseI_casewise = out_phase1_casewise
)
plot_control_charts(out_phase2_casewise)
}

}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Chart.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.
}
