% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_call.R
\name{galah_call}
\alias{galah_call}
\alias{request_data}
\alias{request_metadata}
\alias{request_files}
\title{Start building a request}
\usage{
galah_call(
  type = c("occurrences", "occurrences-count", "occurrences-doi", "species",
    "species-count")
)

request_data(
  type = c("occurrences", "occurrences-count", "occurrences-doi", "species",
    "species-count")
)

request_metadata(
  type = c("fields", "apis", "assertions", "atlases", "collections", "config",
    "datasets", "licences", "lists", "media", "profiles", "providers", "ranks",
    "reasons", "taxa", "identifiers")
)

request_files(type = "media")
}
\arguments{
\item{type}{string: what form of data should be returned? Acceptable values
are specified by the corresponding \code{request} function}
}
\value{
Each sub-function returns a different object class:
\itemize{
\item \code{\link[=request_data]{request_data()}}  and \code{\link[=galah_call]{galah_call()}} return class \code{"data_request"}
\item \code{\link[=request_metadata]{request_metadata()}} returns class \code{"metadata_request"}
\item \code{\link[=request_files]{request_files()}} returns class \code{"files_request"}
}

These objects are list-like and store later dplyr verbs in the order
they are provided.
}
\description{
To download data from the selected atlas, one must construct a query. This
query tells the atlas API what data to download and return, as well as how it
should be filtered. Using \code{\link[=galah_call]{galah_call()}} allows you to build a piped query to
download data, in the same way that you would wrangle data with \code{dplyr} and
the \code{tidyverse}. It is synonymous with \code{\link[=request_data]{request_data()}}; to query other
data types call \code{\link[=request_metadata]{request_metadata()}} or \code{\link[=request_files]{request_files()}}.
}
\details{
\code{\link[=galah_call]{galah_call()}} and any of the \code{request_} functions are used to begin a
piped query, which is then actioned using
\code{\link[=collect.data_request]{collect()}}, or optionally one of the
\code{\link[=atlas_occurrences]{atlas_}} family of functions.

Having distinct functions for different types of request is useful because
it allows \code{galah} to separate different types of requests to perform better.
For example, \code{\link[=filter.data_request]{filter.data_request()}}translates filters
to \code{solr} syntax for the living atlases, or to predicates for GBIF, whereas
\code{\link[=filter.metadata_request]{filter.metadata_request()}} adds a search term to your metadata query.
}
\examples{
\dontrun{ 
# Begin your query with `galah_call()`, then pipe using `\%>\%` or `|>`

# Get number of records of *Aves* from 2001 to 2004 by year
galah_call() |>
  identify("Aves") |>
  filter(year > 2000 & year < 2005) |>
  group_by(year) |>
  count() |>
  collect()
  
# Get information for all species in *Cacatuidae* family
galah_call() |>
  identify("Cacatuidae") |>
  distinct("speciesID", .keep_all = TRUE) |>
  collect()
  
# Download records of genus *Eolophus* from 2001 to 2004
galah_config(email = "your-email@email.com")

galah_call() |>
  identify("Eolophus") |>
  filter(year > 2000 & year < 2005) |>
  collect()
}
}
\seealso{
To amend a request object, use \code{\link[=apply_profile]{apply_profile()}},
\code{\link[=arrange.data_request]{arrange()}},
\code{\link[=count.data_request]{count()}},
\code{\link[=distinct.data_request]{distinct()}},
\code{\link[=filter.data_request]{filter()}},
\code{\link[=glimpse.data_request]{glimpse()}},
\code{\link[=group_by.data_request]{group_by()}},
\code{\link[=identify.data_request]{identify()}},
\code{\link[=select.data_request]{select}},
\code{\link[=slice_head.data_request]{slice_head()}} or \code{\link[=unnest]{unnest()}}.
For operations on \verb{_request} objects, see
\code{\link[=capture]{capture()}},
\code{\link[=compound]{compound()}},
\code{\link[=collapse.data_request]{collapse()}},
\code{\link[=compute.data_request]{compute()}} or
\code{\link[=collect.data_request]{collect()}}.
}
