% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gratia_draw.R
\name{draw.galamm}
\alias{draw.galamm}
\alias{draw}
\title{Draw method for galamm objects}
\usage{
\method{draw}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Other arguments passed on to \code{\link[gratia:draw]{gratia::draw()}}.}
}
\value{
A ggplot object.
}
\description{
This function uses \code{gratia::draw} to visualize smooth terms. See
\code{\link[gratia:draw]{gratia::draw()}} for details. When \code{object} is not of class
\code{galamm}, it is forwarded to \code{gratia::draw()}.
}
\examples{
dat <- subset(cognition, domain == 1 & item == "11")
dat$y <- dat$y[, 1]
mod <- galamm(y ~ s(x) + (1 | id), data = dat)

draw(mod)

}
\seealso{
Other summary functions: 
\code{\link{anova.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.galamm}()},
\code{\link{print.summary.galamm}()},
\code{\link{summary.galamm}()}
}
\concept{summary functions}
