% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_title}
\alias{GC_title}
\title{Add Title to a GC_chart}
\usage{
GC_title(
  GC_chart,
  title = NULL,
  subtitle = NULL,
  style = list(),
  subtitleFont = list(),
  titleFont = list(),
  show = TRUE,
  height = NULL,
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{title}{Character vector. Titles to set for the clusters.}

\item{subtitle}{Character vector. Subtitles to set for the clusters.}

\item{style}{A list of CSS styles to be applied to the chart container. Each
element of the list should be a valid CSS property-value pair. For example,
list(backgroundColor = "white", border = "2px solid black").
Default is an empty list.}

\item{subtitleFont}{List. Settings for the subtitle font.}

\item{titleFont}{List. Settings for the title font.}

\item{show}{Logical. Whether to display the title. Default is TRUE.}

\item{height}{Character. Height for the title (e.g., "50px").}

\item{...}{Additional customization arguments for title and subtitle.}
}
\value{
Updated GC chart with new title settings.
}
\description{
Modify the cluster title and subtitle of specified clusters within a GC chart and adjust
the display settings.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)

# Basic usage
GC_chart(genes_data, cluster ="cluster", group = "group", height = "400px") \%>\%
GC_labels("name") \%>\%
GC_title(
  title = "Cluster 1 Data",
  subtitle = "Detailed View",
  show = TRUE
)

# Customizing title style
GC_chart(genes_data, cluster = "cluster", group = "group", height = "500px") \%>\%
  GC_labels("name") \%>\%
  GC_title(
    title = "Cluster 1 Data",
    subtitle = "Detailed View",
    show = TRUE,
    height = "50px",
    cluster = 1,
    x = 0,
    y = 25, # height / 2
    align = "center",
    spacing = 20,
    style = list(
      backgroundColor = "#0000"
      # Any other CSS styles
    ),
    titleFont = list(
      fontSize = "16px",
      fontStyle = "normal",
      fontWeight = "bold",
      textDecoration = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      fill = "black"
      # Any other CSS styles
    ),
    subtitleFont = list(
      fontSize = "14px",
      fontStyle = "normal",
      fontWeight = "bold",
      textDecoration = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      fill = "black"
      # Any other CSS styles
    )
  )

}
