% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-discrete-distribution.R
\name{scale_discrete_distribution}
\alias{scale_discrete_distribution}
\alias{scale_x_discrete_distribution}
\alias{scale_y_discrete_distribution}
\title{Position scales for discrete distributions}
\usage{
scale_x_discrete_distribution(
  name = waiver(),
  palette = seq_len,
  expand = waiver(),
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver(),
  continuous.limits = NULL,
  drop = TRUE,
  ...
)

scale_y_discrete_distribution(
  name = waiver(),
  palette = seq_len,
  expand = waiver(),
  guide = waiver(),
  position = "left",
  sec.axis = waiver(),
  continuous.limits = NULL,
  drop = TRUE,
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the numerical values
that they should take.}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{sec.axis}{\code{\link[ggplot2:dup_axis]{dup_axis()}} is used to specify a secondary axis.}

\item{continuous.limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing a display range for the scale.
Use \code{NA} to refer to the existing minimum or maximum.
\item A function that accepts the limits and returns a numeric vector of
length two.
}}

\item{drop}{\code{TRUE}, will drop factor levels not associated with data}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\value{
A ggplot2 scale
}
\description{
These scales allow for discrete distributions to be passed to the x and y position by mapping distribution objects
to discrete aesthetics.
These scale can be used similarly to the scale_*_discrete functions.
If you want to transform your scale, you should apply a transformation through the coord_* functions,
as they are applied after the stat, so the existing ggplot infastructure can be used.
}
\examples{
library(ggplot2)
# ggplot
ggplot(smaller_diamonds, aes(x = cut, y = clarity)) +
 geom_count(aes(size = after_stat(prop)))
# ggdibbler
ggplot(smaller_uncertain_diamonds, aes(x = cut, y = clarity)) + 
 geom_count_sample(aes(size = after_stat(prop)), times=10, alpha=0.1)
}
