% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newplots.R
\name{stat_spline}
\alias{stat_spline}
\alias{geom_spline}
\title{Geoms and stats for spline smoothing}
\usage{
stat_spline(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  weight = NULL,
  df = NULL,
  spar = NULL,
  cv = FALSE,
  all.knots = FALSE,
  nknots = stats::.nknots.smspl,
  df.offset = 0,
  penalty = 1,
  control.spar = list(),
  tol = NULL,
  ...
)

geom_spline(
  mapping = NULL,
  data = NULL,
  stat = "spline",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  weight = NULL,
  df = NULL,
  spar = NULL,
  cv = FALSE,
  all.knots = FALSE,
  nknots = stats::.nknots.smspl,
  df.offset = 0,
  penalty = 1,
  control.spar = list(),
  tol = NULL,
  ...
)
}
\arguments{
\item{mapping}{An aesthetic mapping produced with ggplot2::aes()] or
ggplot2::aes_string()].}

\item{data}{A data frame.}

\item{geom}{A geom.}

\item{position}{A position object.}

\item{na.rm}{A logical indicating whether a warning should be issued when
missing values are removed before plotting.}

\item{show.legend}{A logical indicating whether legends should be included
for this layer.  If \code{NA}, legends will be included for each aesthetic
that is mapped.}

\item{inherit.aes}{A logical indicating whether aesthetics should be
inherited.  When \code{FALSE}, the supplied \code{mapping} will be
the only aesthetics used.}

\item{weight}{An optional vector of weights.
See \code{\link[=smooth.spline]{smooth.spline()}}.}

\item{df}{desired equivalent degrees of freedom.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{spar}{A smoothing parameter, typically in (0,1].
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{cv}{A logical.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{all.knots}{A logical.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{nknots}{An integer or function giving the number of knots to use
when \code{all.knots = FALSE}.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{df.offset}{A numerical value used to increase the degrees of freedom
when using GVC.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{penalty}{the coefficient of the penalty for degrees of freedom in the
GVC criterion.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{control.spar}{An optional list used to control root finding
when the parameter \code{spar} is computed.
See \code{\link[=smooth.spline]{smooth.spline()}} for details.}

\item{tol}{A tolerance for sameness or uniqueness of the \code{x} values.
The values are binned into bins of size tol and values which fall into
the same bin are regarded as the same. Must be strictly positive (and finite).
When \code{NULL}, \code{IQR(x) * 10e-6} is used.}

\item{...}{Additional arguments}

\item{stat}{A stat.}
}
\description{
Similar to \link[ggplot2:geom_smooth]{ggplot2::geom_smooth}, this adds spline fits to plots.
}
\examples{
if (require(mosaicData)) {
  ggplot(Births) + geom_spline(aes(x = date, y = births, colour = wday))
  ggplot(Births) + geom_spline(aes(x = date, y = births, colour = wday), nknots = 10)
}
}
