% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_feature.R
\name{geom_feature}
\alias{geom_feature}
\title{A 'ggplot2' geom to draw point genetic features}
\usage{
geom_feature(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE,
  feature_height = unit(3, "mm"),
  feature_width = unit(3, "mm"),
  arrowhead_width = unit(2, "mm"),
  ...
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{As
standard for ggplot2. inherit.aes is set to FALSE by default, as features
are not likely to share any plot aesthetics other than y.}

\item{feature_height}{\code{grid::unit()} object giving the height of a feature
above the molecule line. Can be set as a negative value to draw features
below the line. Defaults to 3 mm.}

\item{feature_width}{\code{grid::unit()} object giving the width of a feature
(distance from the elbow to the tip of the arrow). Only relevant for
oriented features. Defaults to 3 mm.}

\item{arrowhead_width}{\code{grid::unit()} object giving the width of the
arrowhead indicating the direction of an oriented feature. Only relevant for
oriented features. Defaults to 2 mm.}
}
\description{
\code{geom_feature()} draws lines to indicate the positions of point genetic
features, for example restriction sites, origins of replication or
transcription start sites.
}
\details{
Features are drawn as vertical lines extending from the horizontal line
representing the molecule. The position of the feature is expressed with the
\code{x} aesthetic. Optionally, the \code{forward} aesthetic can be used to specific
an orientation for the feature (e.g. the direction of transcription), in
which case an angled arrowhead will be added. The \code{forward} aesthetic
assumes that the x-axis is oriented in the normal direction, i.e. increasing
from left to right; if it is not, the values in \code{forward} will need to be
inverted manually.
}
\section{Aesthetics}{

\itemize{
\item x (required; position of the feature)
\item y (required; molecule)
\item forward (optional; if TRUE, or a value coercible to TRUE, the feature will
be drawn with an arrowhead pointing right, if FALSE, pointing left, if NA,
the feature will be drawn as a vertical line)
\item alpha
\item colour
\item linetype
\item linewidth (the former size aesthetic has been deprecated and will be
removed in future versions)
}
}

\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
                                            y = molecule, fill = gene)) +
  geom_gene_arrow() +
  geom_feature(data = example_features, ggplot2::aes(x = position, y = molecule, 
                                                     forward = forward)) +
  ggplot2::facet_wrap(~ molecule, scales = "free")

}
\seealso{
\code{\link[=geom_feature_label]{geom_feature_label()}}, \code{\link[=geom_terminator]{geom_terminator()}}
}
