% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bed.R
\name{read_bed}
\alias{read_bed}
\title{Read a BED file}
\usage{
read_bed(file, col_names = def_names("bed"), col_types = def_types("bed"), ...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector). \code{file} can also be a character vector
containing multiple filepaths or a list containing multiple connections.

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will be automatically
decompressed. Files starting with \verb{http://}, \verb{https://}, \verb{ftp://}, or
\verb{ftps://} will be automatically downloaded. Remote compressed files
(\code{.gz}, \code{.bz2}, \code{.xz}, \code{.zip}) will be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, wrap the input with \code{I()}.}

\item{col_names}{column names to use. Defaults to \code{def_names("bed")}
compatible with canonical bed files. \code{\link[=def_names]{def_names()}} can easily be
combined with extra columns: \code{col_names = c(def_names("bed"), "more", "things")}.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows of the
input, interspersed throughout the file. This is convenient (and fast),
but not robust. If the guessed types are wrong, you'll need to increase
\code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[readr:cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set \code{options(readr.show_col_types = FALSE)}.}

\item{...}{additional parameters, passed to \code{read_tsv}}
}
\value{
tibble
}
\description{
BED files use 0-based coordinate starts, while gggenomes uses 1-based start
coordinates. BED file coordinates are therefore transformed into 1-based
coordinates during import.
}
