% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglycan.R
\name{geom_glycan}
\alias{geom_glycan}
\title{Glycan Geometry Layer}
\usage{
geom_glycan(
  edge_color = "black",
  edge_width = 0.5,
  arrow_length = unit(2, "mm"),
  node_size = 5,
  node_label = FALSE,
  label_size = 3.88,
  edge_label_size = 3.88,
  ...
)
}
\arguments{
\item{edge_color}{Color of the edges.}

\item{edge_width}{Width of the edges.}

\item{arrow_length}{Length of the edge arrows.}

\item{node_size}{Size of the node symbols.}

\item{node_label}{Logical. Whether to show node labels (monosaccharide names). Default is FALSE.}

\item{label_size}{Size of the node labels.}

\item{edge_label_size}{Size of the edge labels (linkage).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list of `ggplot2` layers.
}
\description{
A convenient wrapper to add edges, edge labels, and SNFG nodes to a glycan plot.
}
\examples{
s <- "Neu5Ac(a2-3)Gal(b1-4)GlcNAc(b1-2)Man(a1-3)Man(b1-4)GlcNAc(b1-4)GlcNAc"
\dontrun{
gglycan(s) + geom_glycan()
}
}
