% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglycan.R
\name{gglycan}
\alias{gglycan}
\title{Plot Glycan Structure}
\usage{
gglycan(
  data,
  mapping = aes(),
  layout = ggtangle::layout_fishbone,
  direction = "left",
  length = 1,
  angle_sep = 30,
  motif = NULL,
  ...
)
}
\arguments{
\item{data}{A glycan graph object (from `read_glycan`) or an IUPAC string.}

\item{mapping}{Default list of aesthetic mappings to use for plot.}

\item{layout}{The layout algorithm to use. Default is `ggtangle::layout_fishbone`. Can be a string ("tree", "nicely") or a function.}

\item{direction}{The direction of the main chain growth ("left", "right", "up", "down"). Default is "left".}

\item{length}{The distance between nodes. Default is 1.}

\item{angle_sep}{The angle separation for branches in degrees. Default is 30.}

\item{motif}{A motif string (IUPAC format) to highlight in the structure. Default is NULL.}

\item{...}{Additional arguments passed to `ggplot`.}
}
\value{
A `ggplot` object.
}
\description{
Visualizes a glycan structure using ggplot2 and ggtangle.
}
\examples{
s <- "Neu5Ac(a2-3)Gal(b1-4)GlcNAc(b1-2)Man(a1-3)Man(b1-4)GlcNAc(b1-4)GlcNAc"
\dontrun{
gglycan(s) + geom_glycan()
}
}
