% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R
\docType{package}
\name{ggmlR-package}
\alias{ggmlR}
\alias{ggmlR-package}
\title{ggmlR: 'GGML' Tensor Operations for Machine Learning}
\description{
Provides 'R' bindings to the 'GGML' tensor library for efficient machine learning computation. Implements core tensor operations including element-wise arithmetic, reshaping, and matrix multiplication. Supports neural network layers (attention, convolutions, normalization), activation functions, and quantization. Features optimization/training API with 'AdamW' (Adam with Weight decay) and 'SGD' (Stochastic Gradient Descent) optimizers, 'MSE' (Mean Squared Error) and cross-entropy losses. Multi-backend support with CPU and optional 'Vulkan' GPU (Graphics Processing Unit) acceleration. See \url{https://github.com/ggml-org/ggml} for more information about the underlying library.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zabis13/ggmlR}
  \item Report bugs at \url{https://github.com/Zabis13/ggmlR/issues}
}

}
\author{
\strong{Maintainer}: Yuri Baramykov \email{lbsbmsu@mail.ru}

Other contributors:
\itemize{
  \item Georgi Gerganov (Author of the GGML library) [contributor, copyright holder]
  \item Jeffrey Quesnelle (Contributor to ops.cpp) [contributor, copyright holder]
  \item Bowen Peng (Contributor to ops.cpp) [contributor, copyright holder]
  \item Mozilla Foundation (Author of llamafile/sgemm.cpp) [contributor, copyright holder]
}

}
\keyword{internal}
