% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\name{ggml_set_no_alloc}
\alias{ggml_set_no_alloc}
\title{Set No Allocation Mode}
\usage{
ggml_set_no_alloc(ctx, no_alloc)
}
\arguments{
\item{ctx}{GGML context}

\item{no_alloc}{Logical, TRUE to disable allocation}
}
\value{
NULL (invisible)
}
\description{
When enabled, tensor creation will not allocate memory for data.
Useful for creating computation graphs without allocating storage.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
ggml_set_no_alloc(ctx, TRUE)
ggml_get_no_alloc(ctx)
ggml_set_no_alloc(ctx, FALSE)
ggml_free(ctx)
}
}
