% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_view_tensor}
\alias{ggml_view_tensor}
\title{View Tensor}
\usage{
ggml_view_tensor(ctx, src)
}
\arguments{
\item{ctx}{GGML context}

\item{src}{Source tensor}
}
\value{
View tensor (shares data with src)
}
\description{
Creates a view of the tensor (shares data, no copy)
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
view <- ggml_view_tensor(ctx, a)
# view shares data with a
ggml_free(ctx)
}
}
