% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\docType{data}
\name{rope_types}
\alias{rope_types}
\alias{GGML_ROPE_TYPE_NORM}
\alias{GGML_ROPE_TYPE_NEOX}
\alias{GGML_ROPE_TYPE_MROPE}
\alias{GGML_ROPE_TYPE_VISION}
\title{RoPE Mode Constants}
\format{
Integer constants

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.
}
\usage{
GGML_ROPE_TYPE_NORM

GGML_ROPE_TYPE_NEOX

GGML_ROPE_TYPE_MROPE

GGML_ROPE_TYPE_VISION
}
\value{
An integer constant representing a RoPE type
}
\description{
RoPE (Rotary Position Embedding) Type Constants
}
\details{
Constants for RoPE (Rotary Position Embedding) modes used in transformer models.
Different models use different RoPE implementations.


\itemize{
  \item \code{GGML_ROPE_TYPE_NORM} (0): Standard RoPE as in original paper (LLaMA, Mistral)
  \item \code{GGML_ROPE_TYPE_NEOX} (2): GPT-NeoX style RoPE with different interleaving
  \item \code{GGML_ROPE_TYPE_MROPE} (8): Multi-RoPE for multimodal models (Qwen2-VL)
  \item \code{GGML_ROPE_TYPE_VISION} (24): Vision model RoPE variant
}
}
\examples{
\donttest{
GGML_ROPE_TYPE_NORM    # 0 - Standard RoPE (LLaMA, Mistral)
GGML_ROPE_TYPE_NEOX    # 2 - GPT-NeoX style
GGML_ROPE_TYPE_MROPE   # 8 - Multi-RoPE (Qwen2-VL)
GGML_ROPE_TYPE_VISION  # 24 - Vision models
}
}
\keyword{datasets}
