% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_count_equal}
\alias{ggml_count_equal}
\title{Count Equal Elements (Graph)}
\usage{
ggml_count_equal(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor}

\item{b}{Second tensor (same shape as a)}
}
\value{
Tensor containing the count of equal elements
}
\description{
Creates a graph node that counts equal elements between two tensors.
Useful for accuracy computation.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
pred <- ggml_new_tensor_1d(ctx, GGML_TYPE_I32, 100)
labels <- ggml_new_tensor_1d(ctx, GGML_TYPE_I32, 100)
# ... set values ...
correct <- ggml_count_equal(ctx, pred, labels)
graph <- ggml_build_forward_expand(ctx, correct)
ggml_graph_compute(ctx, graph)
# correct now contains count of matching elements
ggml_free(ctx)
}
}
\seealso{
Other tensor_layout: 
\code{\link{ggml_are_same_stride}()},
\code{\link{ggml_can_repeat}()},
\code{\link{ggml_is_contiguous_0}()},
\code{\link{ggml_is_contiguous_1}()},
\code{\link{ggml_is_contiguous_2}()},
\code{\link{ggml_is_contiguous_channels}()},
\code{\link{ggml_is_contiguous_rows}()},
\code{\link{ggml_is_contiguously_allocated}()}
}
\concept{tensor_layout}
