% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_cpu_mul}
\alias{ggml_cpu_mul}
\title{Element-wise Multiplication (CPU Direct)}
\usage{
ggml_cpu_mul(a, b)
}
\arguments{
\item{a}{First tensor (must be F32 type)}

\item{b}{Second tensor (must be F32 type, same size as a)}
}
\value{
Numeric vector containing the element-wise product
}
\description{
Performs element-wise multiplication of two tensors using direct CPU computation.
Returns the result as an R numeric vector. Does NOT use computation graphs.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(2, 2, 2, 2, 2))
ggml_cpu_mul(a, b)
ggml_free(ctx)
}
}
