% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{nn_gru_step}
\alias{nn_gru_step}
\title{Build one GRU step}
\usage{
nn_gru_step(
  ctx,
  x_t,
  h_t,
  W_zh,
  U_zh,
  b_zh,
  W_n,
  U_n,
  b_n,
  units,
  act_cell,
  act_rec
)
}
\arguments{
\item{ctx}{ggml compute context}

\item{x_t}{Input at this step: [input_size, N]}

\item{h_t}{Previous hidden state: [units, N]}

\item{W_zh}{[input_size, 2*units]}

\item{U_zh}{[units, 2*units]}

\item{b_zh}{[2*units]}

\item{W_n}{[input_size, units]}

\item{U_n}{[units, units]}

\item{b_n}{[units]}

\item{units}{Integer}

\item{act_cell}{Activation for candidate (tanh)}

\item{act_rec}{Activation for z/r gates (sigmoid)}
}
\value{
list(h = new_h)
}
\description{
Build one GRU step
}
\keyword{internal}
