% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-.R, R/stat-density-.R
\name{geom_density_}
\alias{geom_density_}
\alias{stat_density_}
\title{More general smoothed density estimates}
\usage{
geom_density_(
  mapping = NULL,
  data = NULL,
  stat = "density_",
  position = "identity_",
  ...,
  scale.x = NULL,
  scale.y = c("data", "group", "variable"),
  as.mix = FALSE,
  positive = TRUE,
  prop = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_(
  mapping = NULL,
  data = NULL,
  geom = "density_",
  position = "stack_",
  ...,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  trim = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{scale.x}{A sorted length 2 numerical vector representing
the range of the whole data will be scaled to. The default value is (0, 1).}

\item{scale.y}{one of \code{data} and \code{group} to specify.
\tabular{ll}{ \strong{Type} \tab \strong{Description}
\cr data (default) \tab The density estimates are scaled by the whole data set
\cr group \tab The density estimates are scaled by each group
}
If the \code{scale.y} is \code{data}, it is meaningful to compare the density (shape and area) across all groups; else
it is only meaningful to compare the density within each group. See details.}

\item{as.mix}{Logical. Within each group, if \code{TRUE}, the sum of the density estimate area is mixed and
scaled to maximum 1. The area of each subgroup (in general, within each group one color represents one subgroup)
is proportional to the count; if \code{FALSE} the area of each subgroup is the same, with maximum 1. See details.}

\item{positive}{If \code{y} is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout; up (`positive`) or down (`negative`) as horizontal layout?}

\item{prop}{adjust the proportional maximum height of the estimate (density, histogram, ...).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_density()} and \code{stat_density()}. For more information about
overriding these connections, see how the \link[ggplot2:layer_stats]{stat} and
\link[ggplot2:layer_geoms]{geom} arguments work.}

\item{bw}{The smoothing bandwidth to be used.
If numeric, the standard deviation of the smoothing kernel.
If character, a rule to choose the bandwidth, as listed in
\code{\link[stats:bandwidth]{stats::bw.nrd()}}. Note that automatic calculation of the bandwidth does
not take weights into account.}

\item{adjust}{A multiplicate bandwidth adjustment. This makes it possible
to adjust the bandwidth while still using the a bandwidth estimator.
For example, \code{adjust = 1/2} means use half of the default bandwidth.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{If \code{FALSE}, the default, each density is computed on the
full range of the data. If \code{TRUE}, each density is computed over the
range of that group: this typically means the estimated x values will
not line-up, and hence you won't be able to stack density values.
This parameter only matters if you are displaying multiple densities in
one plot or if you are manually adjusting the scale limits.}
}
\description{
Computes and draws kernel density estimate.
Compared with \code{geom_density()}, it provides more general cases that
accepting \code{x} and \code{y}. See details
}
\details{
The \code{x} (or \code{y}) is a group variable (categorical) and \code{y} (or \code{x}) is the target variable (numerical) to be plotted.
If only one of \code{x} or \code{y} is provided, it will treated as a target variable and
\code{ggplot2::geom_density} will be executed.

There are four combinations of \code{scale.y} and \code{as.mix}.
\describe{
  \item{\code{scale.y} = "group" and \code{as.mix} = FALSE}{The density estimate area of each subgroup (represented by each color)
  within the same group is the same.}
  \item{\code{scale.y} = "group" and \code{as.mix} = TRUE}{The density estimate area of each subgroup (represented by each color)
  within the same group is proportional to its own counts.}
  \item{\code{scale.y} = "data" and \code{as.mix} = FALSE}{The sum of density estimate area of all groups is scaled to maximum of 1.
  and the density area for each group is proportional to the its count. Within each group, the area of each subgroup is the same.}
  \item{\code{scale.y} = "data" and \code{as.mix} = TRUE}{The sum of density estimate area of all groups is scaled to maximum of 1
  and the area of each subgroup (represented by each color) is proportional to its own count.}
}
See vignettes[https://great-northern-diver.github.io/ggmulti/articles/histogram-density-.html] for more intuitive explanation.
}
\section{Orientation}{
 
This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.
}

\examples{
if(require(dplyr)) {
  mpg \%>\%
    dplyr::filter(drv != "f") \%>\%
    ggplot(mapping = aes(x = drv, y = cty, fill = factor(cyl))) +
    geom_density_(alpha = 0.1)

  # only `x` or `y` is provided
  # that would be equivalent to call function `geom_density()`
  diamonds \%>\%
    dplyr::sample_n(500) \%>\%
    ggplot(mapping = aes(x = price)) +
    geom_density_()

  # density and boxplot
  # set the density estimate on the left
  mpg \%>\%
    dplyr::filter(drv != "f") \%>\%
    ggplot(mapping = aes(x = drv, y = cty,
                         fill = factor(cyl))) +
    geom_density_(alpha = 0.1,
                  scale.y = "group",
                  as.mix = FALSE,
                  positive = FALSE) +
    geom_boxplot()

  # x as density
  set.seed(12345)
  suppressWarnings(
    diamonds \%>\%
      dplyr::sample_n(500) \%>\%
      ggplot(mapping = aes(x = price, y = cut, fill = color)) +
      geom_density_(orientation = "x", prop = 0.25,
                    position = "stack_",
                    scale.y = "group")
  )
}
# settings of `scale.y` and `as.mix`
\donttest{
ggplots <- lapply(list(
                      list(scale.y = "data", as.mix = TRUE),
                      list(scale.y = "data", as.mix = FALSE),
                      list(scale.y = "group", as.mix = TRUE),
                      list(scale.y = "group", as.mix = FALSE)
                    ),
                   function(vars) {
                     scale.y <- vars[["scale.y"]]
                     as.mix <- vars[["as.mix"]]
                     ggplot(mpg,
                            mapping = aes(x = drv, y = cty, fill = factor(cyl))) +
                       geom_density_(alpha = 0.1, scale.y = scale.y, as.mix = as.mix) +
                       labs(title = paste("scale.y =", scale.y),
                            subtitle = paste("as.mix =", as.mix))
                   })
suppressWarnings(
  gridExtra::grid.arrange(grobs = ggplots)
)}

}
\seealso{
\code{\link[ggplot2]{geom_density}}, \code{\link{geom_hist_}}
}
