% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmodel.R, R/print.R
\name{bccm}
\alias{bccm}
\alias{print.bccm}
\title{Fitting bccm models}
\usage{
bccm(
  adj,
  labels,
  directed = NULL,
  selfloops = NULL,
  directedBlocks = FALSE,
  homophily = FALSE,
  inBlockOnly = FALSE,
  xi = NULL,
  regular = FALSE,
  ...
)

\method{print}{bccm}(x, suppressCall = FALSE, ...)
}
\arguments{
\item{adj}{the adjacency matrix of the graph.}

\item{labels}{vector or list. contains the vertex labels to generate the blocks in the bccm. In the case of bipartite graphs should be a list of two vectors, the first one with row labels and the second one with column labels.}

\item{directed}{a boolean argument specifying whether the graph is directed or not.}

\item{selfloops}{boolean argument specifying whether the model should incorporate selfloops.}

\item{directedBlocks}{boolean argument specifying whether the model should incorporate directed blocks. Default to FALSE.}

\item{homophily}{boolean argument specifying whether the model should fit only homophily blocks. Default to FALSE.}

\item{inBlockOnly}{boolean argument specifying whether the model should fit only blocks over the diagonal. Default to FALSE.}

\item{xi}{an optional matrix defining the combinatorial matrix of the model.}

\item{regular}{optional boolean, fit regular gnp model? if not specified chosen through lr.test.}

\item{\dots}{optional arguments to print or plot methods.}

\item{x}{object of class \code{'bccm'}}

\item{suppressCall}{logical, indicating whether to print the call that generated x}
}
\value{
bccm returns an object of class 'bccm' and 'ghype'.
'bccm' objects expand 'ghype' objects incorporating the parameter estimates.
}
\description{
bccm is used to fit a block-constrained configuration model.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(bccm)}: Print method for elements of class \code{'bccm'}.

}}
\examples{
data("vertexlabels","adj_karate")
blockmodel <- bccm(adj = adj_karate, labels = vertexlabels, directed = FALSE, selfloops = FALSE)

data('adj_karate')
data('vertexlabels')
bcc.model <- bccm(adj_karate, labels=vertexlabels, directed=FALSE, selfloops=FALSE)
print(bcc.model)

}
\seealso{
\code{\link{bccm}}
}
