% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-census.R
\name{gisco_get_census}
\alias{gisco_get_census}
\title{Census dataset}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/statistical-units/census}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/statistical-units}.
}
\usage{
gisco_get_census(
  year = 2011,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  spatialtype = c("RG", "PT")
)
}
\arguments{
\item{year}{character string or number. Release year of the file. Currently
only \code{"2011"} is provided.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \code{"PT"}: Points - \code{POINT} object.
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
}}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset shows pan European communal boundaries depicting the situation
at the corresponding Census.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
library(sf)

pts <- gisco_get_census(spatialtype = "PT")

pts
}
\dontshow{\}) # examplesIf}
}
\seealso{
See \code{\link[=gisco_id_api_census_grid]{gisco_id_api_census_grid()}} to download via GISCO ID service API.

Other statistical units datasets:
\code{\link{gisco_get_coastal_lines}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{stats}
