% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gce.R
\name{gar_gce_auth_default}
\alias{gar_gce_auth_default}
\title{Authenticate via gcloud's application-default login}
\usage{
gar_gce_auth_default(
  scopes = getOption("googleAuthR.scopes.selected",
    "https://www.googleapis.com/auth/cloud-platform")
)
}
\arguments{
\item{scopes}{The scope you created the access_token with}
}
\description{
This allows you to take gcloud's application-default login token and turns it into one that can be used by R
}
\details{
When authenticating on Google Cloud Platform services, if you are using services that take the cloud scopes you can use \link{gar_gce_auth} to generate authentication.
 
 However, for other services that require a user login (such as Google Analytics API), you need a method of authentication where you can use your own email login.  You have two options - create a token offline and upload it to the instance, or \code{gcloud} allows you to generate your own token online via \code{gcloud auth application-default login && gcloud auth application-default print-access-token}
 
 This function will then take the returned access token and put it within R so it can be used as normal with \code{googleAuthR} functions.
}
\examples{

\dontrun{

## in the terminal, issue this gcloud command specifying the scopes to authenticate with
gcloud auth application-default login \
  --scopes=https://www.googleapis.com/auth/analytics.readonly

## access the URL, login and create a verification code, paste in console.

## view then copy-paste the access token, to be passed into the R function
gcloud auth application-default print-access-token

## In R:
gar_gce_auth_default(<token-copy-pasted>, 
     scopes = 'https://www.googleapis.com/auth/analytics.readonly',
     cache_file = 'my_ga.auth')
                     
# use token to authenticate as you would normally with library
}


}
\seealso{
\href{https://cloud.google.com/sdk/gcloud/reference/auth/application-default/print-access-token}{gcloud reference}
}
