% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBF.R
\name{OBF}
\alias{OBF}
\title{O'Brien-Flemming error spending function.}
\usage{
OBF(t, alpha = 0.05)
}
\arguments{
\item{t}{Mumeric vector of information fractions, typically in \eqn{(0,1)},
where \code{t=1} corresponds to the final analysis.}

\item{alpha}{Overall two-sided Type I error level. Default is \code{0.05}.}
}
\value{
A numeric vector giving the cumulative type I error spent at each information fraction \code{t}
under the O'Brien-Flemming spending function.
}
\description{
Computes the cumulative Type I error spending function corresponding to the two-sided O'Brien-Flemming group
sequential design.
}
\examples{
# Two-interim analyses at 50\% and 75\% maximum information and a final analysis
OBF(t = c(0.5, 0.7, 1))
}
\references{
Jennison, C. and Turnbull, B. W. (2000). \emph{Group Sequential Methods with Applications to Clinical Trials}. Chapman and Hall/CRC.
}
